package com.biz.crm.kms.business.supermarket.parameter.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.supermarket.parameter.local.entity.SupermarketParameterGrabModeEntity;
import com.biz.crm.kms.business.supermarket.parameter.local.mapper.SupermarketParameterGrabModeMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 商超抓单参数表抓单方式表(repository)
 *
 * @author xi.peng
 * @since 2022-09-23 10:49:14
 */
@Component
public class SupermarketParameterGrabModeRepository extends ServiceImpl<SupermarketParameterGrabModeMapper, SupermarketParameterGrabModeEntity> {

  /**
   * 根据ID获取详情
   *
   * @param id
   * @return
   */
  public SupermarketParameterGrabModeEntity findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据supermarketCode获取标签列表
   *
   * @param tenantCode
   * @param supermarketCode
   * @return
   */
  public List<SupermarketParameterGrabModeEntity> findBySupermarketCode(String tenantCode, String supermarketCode) {
    return this.lambdaQuery()
        .eq(SupermarketParameterGrabModeEntity::getTenantCode, tenantCode)
        .eq(SupermarketParameterGrabModeEntity::getSupermarketCode, supermarketCode)
        .list();
  }

  /**
   * 根据supermarketCode集合获取标签列表
   *
   * @param tenantCode
   * @param supermarketCodes
   * @return
   */
  public List<SupermarketParameterGrabModeEntity> findBySupermarketCodes(String tenantCode,String orderType, List<String> supermarketCodes) {
    return this.lambdaQuery()
        .eq(SupermarketParameterGrabModeEntity::getTenantCode, tenantCode)
        .eq(StringUtils.isNotBlank(orderType),SupermarketParameterGrabModeEntity::getOrderType,orderType)
        .in(SupermarketParameterGrabModeEntity::getSupermarketCode, supermarketCodes)
        .list();
  }

  /**
   * 根据supermarketCode删除
   *
   * @param supermarketCode
   */
  public void deleteBySupermarketCode(String supermarketCode) {
    this.lambdaUpdate()
        .eq(SupermarketParameterGrabModeEntity::getSupermarketCode, supermarketCode)
        .remove();
  }

}
