package com.biz.crm.kms.business.supermarket.parameter.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.supermarket.parameter.local.entity.SupermarketParameterLabelEntity;
import com.biz.crm.kms.business.supermarket.parameter.local.mapper.SupermarketParameterLabelMapper;

import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 商超抓单参数表附属标签表(repository)
 *
 * @author xi.peng
 * @since 2022-09-23 10:49:13
 */
@Component
public class SupermarketParameterLabelRepository extends ServiceImpl<SupermarketParameterLabelMapper, SupermarketParameterLabelEntity> {

  /**
   * 根据ID获取详情
   *
   * @param id
   * @return
   */
  public SupermarketParameterLabelEntity findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<SupermarketParameterLabelEntity> findByIds(List<String> ids) {
    return this.lambdaQuery()
        .in(SupermarketParameterLabelEntity::getId, ids)
        .orderByAsc(SupermarketParameterLabelEntity::getSortIndex)
        .list();
  }

  /**
   * 根据parameterId获取标签列表
   *
   * @param parameterId
   * @return
   */
  public List<SupermarketParameterLabelEntity> findByParameterId(String parameterId) {
    return this.lambdaQuery()
        .eq(SupermarketParameterLabelEntity::getParameterId, parameterId)
        .orderByAsc(SupermarketParameterLabelEntity::getSortIndex)
        .list();
  }

  /**
   * 根据parameterId集合获取标签列表
   *
   * @param parameterIds
   * @return
   */
  public List<SupermarketParameterLabelEntity> findByParameterIds(List<String> parameterIds) {
    return this.lambdaQuery()
        .in(SupermarketParameterLabelEntity::getParameterId, parameterIds)
        .orderByAsc(SupermarketParameterLabelEntity::getSortIndex)
        .list();
  }

  /**
   * 根据parameterId删除
   *
   * @param parameterId
   */
  public void deleteByParameterId(String parameterId) {
    this.lambdaUpdate()
        .eq(SupermarketParameterLabelEntity::getParameterId, parameterId)
        .remove();
  }
}
