package com.biz.crm.kms.business.supermarket.parameter.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.kms.business.supermarket.parameter.local.entity.SupermarketParameterOptionEntity;
import com.biz.crm.kms.business.supermarket.parameter.local.mapper.SupermarketParameterOptionMapper;

import java.util.List;

import org.springframework.stereotype.Component;

/**
 * 商超抓单参数表附属选项表(repository)
 *
 * @author xi.peng
 * @since 2022-09-23 10:49:14
 */
@Component
public class SupermarketParameterOptionRepository extends ServiceImpl<SupermarketParameterOptionMapper, SupermarketParameterOptionEntity> {

  /**
   * 根据ID获取详情
   *
   * @param id
   * @return
   */
  public SupermarketParameterOptionEntity findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<SupermarketParameterOptionEntity> findByIds(List<String> ids) {
    return this.lambdaQuery()
        .in(SupermarketParameterOptionEntity::getId, ids)
        .orderByAsc(SupermarketParameterOptionEntity::getSortIndex)
        .list();
  }

  /**
   * 根据parameterId获取标签列表
   *
   * @param parameterId
   * @return
   */
  public List<SupermarketParameterOptionEntity> findByParameterId(String parameterId) {
    return this.lambdaQuery()
        .eq(SupermarketParameterOptionEntity::getParameterId, parameterId)
        .orderByAsc(SupermarketParameterOptionEntity::getSortIndex)
        .list();
  }

  /**
   * 根据parameterId集合获取标签列表
   *
   * @param parameterIds
   * @return
   */
  public List<SupermarketParameterOptionEntity> findByParameterIds(List<String> parameterIds) {
    return this.lambdaQuery()
        .in(SupermarketParameterOptionEntity::getParameterId, parameterIds)
        .orderByAsc(SupermarketParameterOptionEntity::getSortIndex)
        .list();
  }

  /**
   * 根据parameterId删除
   *
   * @param parameterId
   */
  public void deleteByParameterId(String parameterId) {
    this.lambdaUpdate()
        .eq(SupermarketParameterOptionEntity::getParameterId, parameterId)
        .remove();
  }

}
