package com.biz.crm.kms.business.supermarket.parameter.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.kms.business.supermarket.parameter.local.entity.SupermarketParameterEntity;
import com.biz.crm.kms.business.supermarket.parameter.local.mapper.SupermarketParameterMapper;

import java.util.List;

import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.dto.SupermarketParameterPageDto;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterVo;
import org.springframework.stereotype.Component;

/**
 * 商超抓单参数表(repository)
 *
 * @author xi.peng
 * @since 2022-09-23 10:47:58
 */
@Component
public class SupermarketParameterRepository extends ServiceImpl<SupermarketParameterMapper, SupermarketParameterEntity> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<SupermarketParameterVo> findByConditions(Page<SupermarketParameterPageDto> page, SupermarketParameterPageDto dto) {
    return this.baseMapper.findByConditions(page, dto);
  }

  /**
   * 条件查询
   *
   * @param dto
   * @return
   */
  public List<SupermarketParameterVo> findListByConditions(SupermarketParameterDto dto) {
    return this.baseMapper.findByConditions(dto);
  }

  /**
   * 根据ID获取详情
   *
   * @param id
   * @return
   */
  public SupermarketParameterEntity findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<SupermarketParameterEntity> findByIds(List<String> ids) {
    return this.lambdaQuery()
        .eq(SupermarketParameterEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(SupermarketParameterEntity::getId, ids)
        .list();
  }

  /**
   * 根据商超编码获取商超抓单参数集合
   *
   * @param supermarketCode 商超编码
   * @return
   */
  public List<SupermarketParameterEntity> findBySupermarketCode(String supermarketCode) {
    return this.lambdaQuery()
        .eq(SupermarketParameterEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .eq(SupermarketParameterEntity::getSupermarketCode, supermarketCode)
        .list();
  }

  /**
   * 根据商超编码获取商超抓单参数集合
   *
   * @param supermarketCodes 商超编码集合
   * @return
   */
  public List<SupermarketParameterEntity> findBySupermarketCodes(List<String> supermarketCodes) {
    return this.lambdaQuery()
        .eq(SupermarketParameterEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .in(SupermarketParameterEntity::getSupermarketCode, supermarketCodes)
        .list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate()
        .in(SupermarketParameterEntity::getId, ids)
        .set(SupermarketParameterEntity::getEnableStatus, enable.getCode())
        .update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate().in(SupermarketParameterEntity::getId, ids)
        .set(SupermarketParameterEntity::getDelFlag, DelFlagStatusEnum.DELETE.getCode())
        .update();
  }
}
