package com.biz.crm.kms.business.supermarket.parameter.local.service.notifier;

import com.biz.crm.kms.business.supermarket.parameter.sdk.service.SupermarketParameterVoService;
import com.biz.crm.kms.business.supermarket.parameter.sdk.vo.SupermarketParameterVo;
import com.biz.crm.kms.business.supermarket.sdk.listener.SupermarketOperationListener;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 商超管理操作监听器实现
 *
 * @author pengxi
 */
@Slf4j
@Component
public class SupermarketParameterListenerImpl implements SupermarketOperationListener {

  @Autowired(required = false) private SupermarketParameterVoService supermarketParameterVoService;

  /**
   * 启用时，通知上层业务进行业务处理
   *
   * @param supermarketCodes 商超编码集合
   */
  @Override
  public void onEnable(List<String> supermarketCodes) {
    List<SupermarketParameterVo> supermarketParameterVos = this.supermarketParameterVoService.findBySupermarketCodes(supermarketCodes);
    if (CollectionUtils.isEmpty(supermarketParameterVos)) {
      return;
    }
    List<String> ids = supermarketParameterVos.stream().map(SupermarketParameterVo::getId).distinct().collect(Collectors.toList());
    this.supermarketParameterVoService.enableBatch(ids);
    log.info("商超启用时被通知启用的商超抓单参数ID集合：{}", ids);
  }

  /**
   * 禁用时，通知上层业务进行业务处理
   *
   * @param supermarketCodes 商超编码集合
   */
  @Override
  public void onDisable(List<String> supermarketCodes) {
    List<SupermarketParameterVo> supermarketParameterVos = this.supermarketParameterVoService.findBySupermarketCodes(supermarketCodes);
    if (CollectionUtils.isEmpty(supermarketParameterVos)) {
      return;
    }
    List<String> ids = supermarketParameterVos.stream().map(SupermarketParameterVo::getId).distinct().collect(Collectors.toList());
    this.supermarketParameterVoService.disableBatch(ids);
    log.info("商超禁用时被通知禁用的商超抓单参数ID集合：{}", ids);
  }

  /**
   * 删除时，通知上层业务进行业务处理
   *
   * @param supermarketCodes 商超编码集合
   */
  @Override
  public void onDelete(List<String> supermarketCodes) {
    List<SupermarketParameterVo> supermarketParameterVos = this.supermarketParameterVoService.findBySupermarketCodes(supermarketCodes);
    if (CollectionUtils.isEmpty(supermarketParameterVos)) {
      return;
    }
    List<String> ids = supermarketParameterVos.stream().map(SupermarketParameterVo::getId).distinct().collect(Collectors.toList());
    this.supermarketParameterVoService.updateDelFlagByIds(ids);
    log.info("商超删除时被通知删除的商超抓单参数ID集合：{}", ids);
  }
  
}
