package com.biz.crm.kms.business.supermarket.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 商超管理dto
 *
 * @author songjingen
 * @date 2022/9/22
 */
@Getter
@Setter
@ApiModel(value = "SupermarketDto", description = "商超管理dto")
public class SupermarketDto {
  private static final long serialVersionUID = -1187141282677414153L;

  private String tenantCode;

  /**
   * 启禁用状态
   */
  @ApiModelProperty("启禁用状态")
  private String enableStatus;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;

  /**
   * 商超系统名称
   */
  @ApiModelProperty("商超系统名称")
  private String supermarketName;

  /**
   * 关联零售商编码
   */
  @ApiModelProperty("关联零售商编码")
  private String customerRetailerCode;

  /**
   * 关联零售商名称
   */
  @ApiModelProperty("关联零售商名称")
  private String customerRetailerName;
}
