package com.biz.crm.kms.business.supermarket.sdk.listener;

import java.util.List;

/**
 * 商超管理操作监听器
 *
 * @author songjingen
 * @date 2022/9/27
 */
public interface SupermarketOperationListener {

  /**
   * 启用时，通知上层业务进行业务处理
   *
   * @param supermarketCodes 商超编码集合
   */
  default void onEnable(List<String> supermarketCodes) {
  }

  /**
   * 禁用时，通知上层业务进行业务处理
   *
   * @param supermarketCodes 商超编码集合
   */
  default void onDisable(List<String> supermarketCodes) {
  }

  /**
   * 删除时，通知上层业务进行业务处理
   *
   * @param supermarketCodes 商超编码集合
   */
  default void onDelete(List<String> supermarketCodes) {
  }
}
