package com.biz.crm.kms.business.supermarket.sdk.service;

import com.biz.crm.kms.business.supermarket.sdk.vo.SupermarketVo;

import java.util.List;
import java.util.Set;

/**
 * 商超voService
 *
 * @author songjingen
 * @date 2022/9/23
 */
public interface SupermarketVoService {

  /**
   * 根据商超编码集合查询对象
   *
   * @param supermarketCodes 商超编码集合
   * @return 商超信息
   */
  List<SupermarketVo> findBySupermarketCodes(Set<String> supermarketCodes);

  /**
   * 根据零售商名称查零售商编码
   * @param supermarketNames
   * @return
   */
  List<SupermarketVo> findBySupermaketNames(Set<String> supermarketNames);

  /**
   * 获取全部零售商数据
   */
  List<SupermarketVo> findAllSupermarket();
}
