package com.biz.crm.kms.business.supermarket.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 商超区域vo
 *
 * @author songjingen
 * @date 2022/9/22
 */
@Getter
@Setter
@ApiModel(value = "SupermarketAreaVo", description = "商超区域vo")
public class SupermarketAreaVo extends UuidVo {

  private static final long serialVersionUID = -8531945642061423466L;
  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;

  /**
   * 区域编码
   */
  @ApiModelProperty("区域编码")
  private String areaCode;

  /**
   * 区域名称
   */
  @ApiModelProperty("区域名称")
  private String areaName;
}
