package com.biz.crm.kms.business.supermarket.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Set;

/**
 * 商超管理vo
 *
 * @author songjingen
 * @date 2022/9/22
 */
@Getter
@Setter
@ApiModel(value = "SupermarketVo", description = "商超管理vo")
public class SupermarketVo extends TenantFlagOpVo {
  private static final long serialVersionUID = -1187141282677414153L;

  /**
   * 商超编码
   */
  @ApiModelProperty("商超编码")
  private String supermarketCode;

  /**
   * 商超系统名称
   */
  @ApiModelProperty("商超系统名称")
  private String supermarketName;

  /**
   * 关联零售商编码
   */
  @ApiModelProperty("关联零售商编码")
  private String customerRetailerCode;

  /**
   * 关联零售商名称
   */
  @ApiModelProperty("关联零售商名称")
  private String customerRetailerName;

  /**
   * 商超系统地址
   */
  @ApiModelProperty("商超系统地址")
  private String supermarketUrl;

  /**
   * 单据类型
   */
  @ApiModelProperty("单据类型")
  private String invoiceType;

  /**
   * 区域数据集合
   */
  @ApiModelProperty("区域数据集合")
  private Set<SupermarketAreaVo> supermarketAreas;
}
