/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.lansexiongdipay.service.impl;

import com.biz.crm.lansexiongdipay.common.AccountTypeEnum;
import com.biz.crm.lansexiongdipay.core.Config;
import com.biz.crm.lansexiongdipay.service.LanSeXiongDiService;
import com.lansexiongdi.api.model.BalanceQueryRequest;
import com.lansexiongdi.api.model.BalanceQueryResponse;
import com.lansexiongdi.api.model.OrderCreateRequest;
import com.lansexiongdi.api.model.OrderCreateResponse;
import com.lansexiongdi.api.model.OrderQueryRequest;
import com.lansexiongdi.api.model.OrderQueryResponse;
import com.lansexiongdi.api.model.OrderResendRequest;
import com.lansexiongdi.api.model.OrderResendResponse;
import com.lansexiongdi.api.model.ProductQueryRequest;
import com.lansexiongdi.api.model.ProductQueryResponse;
import com.lansexiongdi.notify.Notify;
import com.lansexiongdi.notify.NotifyOrderReq;
import com.lansexiongdi.sdk.AcsRequest;
import com.lansexiongdi.sdk.IAcsClient;
import com.lansexiongdi.sdk.exceptions.ClientException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class LanSeXiongDiServiceImpl
implements LanSeXiongDiService {
    private final IAcsClient acsClient;
    private final Notify notifyClient;
    private final String merchantId;

    private LanSeXiongDiServiceImpl(Builder builder) {
        this.acsClient = builder.acsClient;
        this.notifyClient = builder.notifyClient;
        this.merchantId = builder.merchantId;
    }

    @Override
    public OrderCreateResponse createOrder(OrderCreateRequest request) throws ClientException {
        Validate.notNull((Object)request, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOutTradeNo(), (String)"\u5546\u6237\u4fa7\u8ba2\u5355\u53f7[outTradeNo]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getProductId(), (String)"\u4ea7\u54c1\u7f16\u7801[productId]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((request.getNumber() != null && request.getNumber() > 0 ? 1 : 0) != 0, (String)"\u8ba2\u5355\u6570\u91cf[number]\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNotifyUrl(), (String)"\u56de\u8c03\u5730\u5740[notifyUrl]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((request.getAccountType() != null && AccountTypeEnum.isValidateCode(request.getAccountType()) ? 1 : 0) != 0, (String)"\u8d26\u53f7\u7c7b\u578b[accountType]\u4e0d\u5408\u6cd5", (Object[])new Object[0]);
        this.setDefaultMerchantId((AcsRequest)request);
        return (OrderCreateResponse)this.acsClient.getAcsResponse((AcsRequest)request);
    }

    @Override
    public OrderQueryResponse queryOrder(OrderQueryRequest request) throws ClientException {
        Validate.notNull((Object)request, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOutTradeNo(), (String)"\u5546\u6237\u4fa7\u8ba2\u5355\u53f7[outTradeNo]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.setDefaultMerchantId((AcsRequest)request);
        return (OrderQueryResponse)this.acsClient.getAcsResponse((AcsRequest)request);
    }

    @Override
    public ProductQueryResponse queryProduct(ProductQueryRequest request) throws ClientException {
        Validate.notNull((Object)request, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.setDefaultMerchantId((AcsRequest)request);
        return (ProductQueryResponse)this.acsClient.getAcsResponse((AcsRequest)request);
    }

    @Override
    public BalanceQueryResponse queryBalance(BalanceQueryRequest request) throws ClientException {
        Validate.notNull((Object)request, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.setDefaultMerchantId((AcsRequest)request);
        return (BalanceQueryResponse)this.acsClient.getAcsResponse((AcsRequest)request);
    }

    @Override
    public OrderResendResponse orderResend(OrderResendRequest request) throws ClientException {
        Validate.notNull((Object)request, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getOutTradeNo(), (String)"\u5546\u6237\u4fa7\u8ba2\u5355\u53f7[outTradeNo]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.setDefaultMerchantId((AcsRequest)request);
        return (OrderResendResponse)this.acsClient.getAcsResponse((AcsRequest)request);
    }

    @Override
    public NotifyOrderReq parseAndVerifyNotify(String body, String authorization) throws Exception {
        Validate.notBlank((CharSequence)body, (String)"\u56de\u8c03\u4f53[body]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)authorization, (String)"\u6388\u6743\u4fe1\u606f[authorization]\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.notifyClient.parseAndVerify(body, authorization);
    }

    private void setDefaultMerchantId(AcsRequest request) {
        if (StringUtils.isEmpty((CharSequence)request.getMerchantId())) {
            request.setMerchantId(this.merchantId);
        }
    }

    public static class Builder {
        private IAcsClient acsClient;
        private Notify notifyClient;
        private String merchantId;

        public Builder config(Config config) {
            this.acsClient = config.acsClient();
            this.notifyClient = config.notifyClient();
            this.merchantId = config.getMerchantId();
            return this;
        }

        public LanSeXiongDiService build() {
            return new LanSeXiongDiServiceImpl(this);
        }
    }
}

