package com.biz.crm.lansexiongdipay.common;

public enum AccountTypeEnum {
    PHONE(1, "手机号"),
    QQ(2, "QQ号"),
    OTHER(0, "其他账号类型");

    private final int code;
    private final String desc;

    AccountTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /***
     * 验证code是否合法
     * @param code
     * @return
     */
    public static boolean isValidateCode(int code) {
        for (AccountTypeEnum type : AccountTypeEnum.values()) {
            if (type.getCode() == code) {
                return true;
            }
        }
        return false;
    }
}
