package com.biz.crm.lansexiongdipay.core;

import com.lansexiongdi.notify.Notify;
import com.lansexiongdi.sdk.DefaultAcsClient;
import com.lansexiongdi.sdk.IAcsClient;
import com.lansexiongdi.sdk.http.ProtocolType;
import com.lansexiongdi.sdk.profile.DefaultProfile;

import static java.util.Objects.requireNonNull;

public final class AcsClientConfig implements Config {

    protected final ProtocolType protocolType;
    protected final String  regionId;
    protected final String  secretKey;
    protected final String  merchantId;


    private AcsClientConfig(Builder builder) {
        this.regionId=builder.regionId;
        this.secretKey=builder.secretKey;
        this.protocolType=builder.protocolType;
        this.merchantId=builder.merchantId;
    }

    public static class Builder  {
        protected  ProtocolType protocolType;
        protected  String  regionId;
        protected  String  secretKey;
        protected  String  merchantId;

        public Builder protocolType(ProtocolType protocolType) {
            this.protocolType = protocolType;
            return this;
        }
        public Builder regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }
        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }
        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }
        public AcsClientConfig build() {
            AcsClientConfig.Builder providerBuilder =
                    new Builder()
                            .protocolType(protocolType)
                            .regionId(requireNonNull(regionId))
                            .merchantId(requireNonNull(merchantId))
                            .secretKey(requireNonNull(secretKey));
            return new AcsClientConfig(providerBuilder);
        }
    }

    @Override
    public IAcsClient acsClient() {
        DefaultProfile profile = DefaultProfile.getProfile(protocolType, regionId, secretKey);
        return new DefaultAcsClient(profile);
    }

    @Override
    public Notify notifyClient() {
        return  new Notify(merchantId, secretKey);
    }

    @Override
    public String getMerchantId() {
        return this.merchantId;
    }
}
