package com.biz.crm.lansexiongdipay.service;

import com.lansexiongdi.api.model.*;
import com.lansexiongdi.notify.NotifyOrderReq;
import com.lansexiongdi.sdk.exceptions.ClientException;

/***
 * 蓝色兄弟开放平台API相关接口
 * 接口文档：https://tvd8jq9lqkp.feishu.cn/wiki/BdbuwSa1oiYtz3k9hILcMY1xnZe
 */
public interface LanSeXiongDiService {

    /***
     * 创建订单-用于创建充值订单、卡密订单
     * @param request
     * @return
     */
    OrderCreateResponse createOrder(OrderCreateRequest request) throws ClientException;
    /***
     * 查询订单-用于查询订单信息
     * @param request
     * @return
     */
    OrderQueryResponse queryOrder(OrderQueryRequest request) throws ClientException;
    /**
     * 查询商品信息-用于获取授权的商品
     * @param request
     * @return
     */
    ProductQueryResponse queryProduct(ProductQueryRequest request) throws ClientException;

    /***
     * 获取余额-用于获取商户余额
     * @param request
     * @return
     */
    BalanceQueryResponse queryBalance(BalanceQueryRequest request) throws ClientException;

    /**
     * 重新发送卡密短信-当客户因为某些原因未收到提取卡密信息时，可以调用此接口重新发送短信
     * (平台订单号；与outTradeNo二选一)
     * @param request
     * @return
     */
    OrderResendResponse orderResend(OrderResendRequest request) throws ClientException;

    /***
     * 解析并验证通知信息
     * @param body 请求体
     * @param authorization
     * @return
     */
    NotifyOrderReq parseAndVerifyNotify(String body,String authorization) throws Exception;
}
