package com.biz.crm.lansexiongdipay.service.impl;

import com.biz.crm.lansexiongdipay.common.AccountTypeEnum;
import com.biz.crm.lansexiongdipay.core.Config;
import com.biz.crm.lansexiongdipay.service.LanSeXiongDiService;
import com.lansexiongdi.api.model.*;
import com.lansexiongdi.notify.Notify;
import com.lansexiongdi.notify.NotifyOrderReq;
import com.lansexiongdi.sdk.AcsRequest;
import com.lansexiongdi.sdk.IAcsClient;
import com.lansexiongdi.sdk.exceptions.ClientException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class LanSeXiongDiServiceImpl implements LanSeXiongDiService {
    private final IAcsClient acsClient;
    private final Notify notifyClient;
    private final  String  merchantId;


    private LanSeXiongDiServiceImpl(Builder builder) {
        this.acsClient = builder.acsClient;
        this.notifyClient = builder.notifyClient;
        this.merchantId = builder.merchantId;
    }
    public static class Builder {

        private IAcsClient acsClient;
        private  Notify notifyClient;
        private  String merchantId;

        public Builder config(Config config) {
            this.acsClient = config.acsClient();
            this.notifyClient = config.notifyClient();
            this.merchantId = config.getMerchantId();
            return this;
        }

        public LanSeXiongDiService build() {
            return new LanSeXiongDiServiceImpl(this);
        }
    }

    @Override
    public OrderCreateResponse createOrder(OrderCreateRequest request) throws ClientException {
            //1.验证参数
            Validate.notNull(request, "传入对象不能为空");
            Validate.notBlank(request.getOutTradeNo(), "商户侧订单号[outTradeNo]不能为空");
            Validate.notBlank(request.getProductId(), "产品编码[productId]不能为空");
            Validate.isTrue(request.getNumber()!=null && request.getNumber() > 0, "订单数量[number]不能为空且必须大于0");
            Validate.notBlank(request.getNotifyUrl(), "回调地址[notifyUrl]不能为空");
            Validate.isTrue(request.getAccountType()!=null&& AccountTypeEnum.isValidateCode(request.getAccountType()),"账号类型[accountType]不合法");
            //2.设置默认的商户号
            setDefaultMerchantId(request);
            //3.创建订单请求
            return acsClient.getAcsResponse(request);
    }

    @Override
    public OrderQueryResponse queryOrder(OrderQueryRequest request) throws ClientException {
        //1.验证入参
        Validate.notNull(request, "传入对象不能为空");
        Validate.notBlank(request.getOutTradeNo(), "商户侧订单号[outTradeNo]不能为空");
        //2.设置默认的商户号
        setDefaultMerchantId(request);
        //2.查询订单请求
        return acsClient.getAcsResponse(request);
    }

    @Override
    public ProductQueryResponse queryProduct(ProductQueryRequest request) throws ClientException {
        //1.验证入参
        Validate.notNull(request, "传入对象不能为空");
        //2.设置默认的商户号
        setDefaultMerchantId(request);
        //3.查询商品请求
        return acsClient.getAcsResponse(request);
    }

    @Override
    public BalanceQueryResponse queryBalance(BalanceQueryRequest request) throws ClientException {
        //1.验证入参
        Validate.notNull(request, "传入对象不能为空");
        //2.设置默认的商户号
        setDefaultMerchantId(request);
        //3.发送请法就
        return acsClient.getAcsResponse(request);
    }

    @Override
    public OrderResendResponse orderResend(OrderResendRequest request) throws ClientException {
        //1.验证入参
        Validate.notNull(request, "传入对象不能为空");
        Validate.notBlank(request.getOutTradeNo(), "商户侧订单号[outTradeNo]不能为空");
        //2.设置默认的商户号
        setDefaultMerchantId(request);
        //3.发送请法就
        return acsClient.getAcsResponse(request);
    }

    @Override
    public NotifyOrderReq parseAndVerifyNotify(String body, String authorization) throws Exception {
         //1.验证入参
        Validate.notBlank(body, "回调体[body]不能为空");
        Validate.notBlank(authorization, "授权信息[authorization]不能为空");
        //2.验证回调参数
        return notifyClient.parseAndVerify(body, authorization);
    }

    private void setDefaultMerchantId(AcsRequest request) {
        if (StringUtils.isEmpty(request.getMerchantId())) {
            request.setMerchantId(merchantId);
        }
    }
}