/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.lansexiongdipay.core;

import com.biz.crm.lansexiongdipay.core.Config;
import com.lansexiongdi.notify.Notify;
import com.lansexiongdi.sdk.DefaultAcsClient;
import com.lansexiongdi.sdk.IAcsClient;
import com.lansexiongdi.sdk.http.ProtocolType;
import com.lansexiongdi.sdk.profile.DefaultProfile;
import com.lansexiongdi.sdk.profile.IClientProfile;
import java.util.Objects;

public final class AcsClientConfig
implements Config {
    protected final ProtocolType protocolType;
    protected final String regionId;
    protected final String secretKey;
    protected final String merchantId;

    private AcsClientConfig(Builder builder) {
        this.regionId = builder.regionId;
        this.secretKey = builder.secretKey;
        this.protocolType = builder.protocolType;
        this.merchantId = builder.merchantId;
    }

    @Override
    public IAcsClient acsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((ProtocolType)this.protocolType, (String)this.regionId, (String)this.secretKey);
        return new DefaultAcsClient((IClientProfile)profile);
    }

    @Override
    public Notify notifyClient() {
        return new Notify(this.merchantId, this.secretKey);
    }

    @Override
    public String getMerchantId() {
        return this.merchantId;
    }

    public static class Builder {
        protected ProtocolType protocolType;
        protected String regionId;
        protected String secretKey;
        protected String merchantId;

        public Builder protocolType(ProtocolType protocolType) {
            this.protocolType = protocolType;
            return this;
        }

        public Builder regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        public Builder merchantId(String merchantId) {
            this.merchantId = merchantId;
            return this;
        }

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public AcsClientConfig build() {
            Builder providerBuilder = new Builder().protocolType(this.protocolType).regionId(Objects.requireNonNull(this.regionId)).merchantId(Objects.requireNonNull(this.merchantId)).secretKey(Objects.requireNonNull(this.secretKey));
            return new AcsClientConfig(providerBuilder);
        }
    }
}

