/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mall.commodity.local.entity.GoodsClassify;
import com.biz.crm.mall.commodity.local.mapper.GoodsClassifyMapper;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationQueryDto;
import com.biz.crm.mall.commodity.sdk.vo.CommodityClassificationVo;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CommodityClassificationRepository
extends ServiceImpl<GoodsClassifyMapper, GoodsClassify> {
    private final GoodsClassifyMapper mapper;

    public CommodityClassificationRepository(GoodsClassifyMapper mapper) {
        this.mapper = mapper;
    }

    public IPage<CommodityClassificationVo> findByCondition(Pageable pageable, CommodityClassificationQueryDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50).first());
        dto = (CommodityClassificationQueryDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CommodityClassificationQueryDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        this.mapper.findByCondition((Page<CommodityClassificationVo>)page, dto);
        return page;
    }

    public List<CommodityClassificationVo> findAll() {
        return this.mapper.findAll();
    }

    public CommodityClassificationVo findById(String id) {
        CommodityClassificationQueryDto dto = new CommodityClassificationQueryDto();
        dto.setId(id);
        IPage<CommodityClassificationVo> page = this.findByCondition((Pageable)PageRequest.of((int)1, (int)10), dto);
        Validate.isFalse((boolean)CollectionUtils.isEmpty((Collection)page.getRecords()), (String)"\u6ca1\u6709\u8be5\u5206\u7c7b\u5c42\u7ea7");
        CommodityClassificationVo vo = (CommodityClassificationVo)page.getRecords().get(0);
        Validate.isTrue((boolean)vo.getId().equals(id), (String)"\u6ca1\u6709\u8be5\u5206\u7c7b\u5c42\u7ea7");
        return vo;
    }
}

