/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mall.commodity.local.entity.GoodsBase;
import com.biz.crm.mall.commodity.local.entity.GoodsPicture;
import com.biz.crm.mall.commodity.local.mapper.GoodsBaseMapper;
import com.biz.crm.mall.commodity.local.mapper.GoodsPictureMapper;
import com.biz.crm.mall.commodity.local.repository.PictureCommodityRepository;
import com.biz.crm.mall.commodity.sdk.dto.CommodityQueryDto;
import com.biz.crm.mall.commodity.sdk.vo.CommodityVo;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CommodityRepository
extends ServiceImpl<GoodsBaseMapper, GoodsBase> {
    private final GoodsBaseMapper mapper;
    private final GoodsPictureMapper pictureMapper;
    @Resource
    private PictureCommodityRepository pictureRepository;

    public CommodityRepository(GoodsBaseMapper mapper, GoodsPictureMapper pictureMapper) {
        this.mapper = mapper;
        this.pictureMapper = pictureMapper;
    }

    public IPage<CommodityVo> findByCondition(Pageable pageable, CommodityQueryDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50).first());
        dto = (CommodityQueryDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CommodityQueryDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        this.mapper.findByCondition((Page<CommodityVo>)page, dto);
        return page;
    }

    public IPage<CommodityVo> findSaleByCondition(Pageable pageable, CommodityQueryDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50).first());
        dto = (CommodityQueryDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CommodityQueryDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        this.mapper.findSaleByCondition((Page<CommodityVo>)page, dto);
        return page;
    }

    public List<GoodsBase> findByCondition(GoodsBase condition) {
        QueryWrapper wrapper = null;
        wrapper = condition == null ? Wrappers.query((Object)((Object)new GoodsBase())) : Wrappers.query((Object)((Object)condition));
        return this.mapper.selectList((Wrapper)wrapper);
    }

    public GoodsBase findByCode(String code) {
        GoodsBase condition = new GoodsBase();
        condition.setCode(code);
        List<GoodsBase> list = this.findByCondition(condition);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    public void store(GoodsBase goodsBase) {
        int update = this.mapper.updateById((Object)goodsBase);
        if (update > 0) {
            QueryWrapper wrapper = Wrappers.query();
            wrapper.eq((Object)"goods_base_id", (Object)goodsBase.getId());
            this.pictureRepository.remove((Wrapper)wrapper);
        } else {
            this.mapper.insert((Object)goodsBase);
        }
        HashSet<GoodsPicture> pictures = new HashSet<GoodsPicture>();
        pictures.addAll(goodsBase.getPicturesForBanner());
        pictures.addAll(goodsBase.getPicturesForDetail());
        pictures.add(goodsBase.getPictureForList());
        this.pictureRepository.saveBatch(pictures);
    }
}

