/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mall.commodity.local.entity.GoodsStore;
import com.biz.crm.mall.commodity.local.mapper.GoodsStoreMapper;
import com.biz.crm.mall.commodity.local.mapper.StoreAgreementConfigMapper;
import com.biz.crm.mall.commodity.local.mapper.StoreChannelConfigMapper;
import com.biz.crm.mall.commodity.local.mapper.StoreParticipantConfigMapper;
import com.biz.crm.mall.commodity.local.repository.PictureStoreRepository;
import com.biz.crm.mall.commodity.sdk.dto.CommodityStoreQueryDto;
import com.biz.crm.mall.commodity.sdk.dto.MobileStoreQueryDto;
import com.biz.crm.mall.commodity.sdk.vo.CommodityStoreVo;
import com.biz.crm.mall.commodity.sdk.vo.MobileStoreVo;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class CommodityStoreRepository
extends ServiceImpl<GoodsStoreMapper, GoodsStore> {
    private final GoodsStoreMapper storeMapper;
    private final StoreAgreementConfigMapper agreementConfigMapper;
    private final StoreChannelConfigMapper channelConfigMapper;
    private final StoreParticipantConfigMapper participantConfigMapper;
    @Resource
    private PictureStoreRepository pictureStoreRepository;

    public CommodityStoreRepository(GoodsStoreMapper storeMapper, StoreAgreementConfigMapper agreementConfigMapper, StoreChannelConfigMapper channelConfigMapper, StoreParticipantConfigMapper participantConfigMapper) {
        this.storeMapper = storeMapper;
        this.agreementConfigMapper = agreementConfigMapper;
        this.channelConfigMapper = channelConfigMapper;
        this.participantConfigMapper = participantConfigMapper;
    }

    public List<GoodsStore> findByCondition(GoodsStore condition) {
        QueryWrapper wrapper = null;
        wrapper = null == condition ? Wrappers.query() : Wrappers.query((Object)((Object)condition));
        return this.storeMapper.selectList((Wrapper)wrapper);
    }

    public void store(GoodsStore store) {
        if (null == store) {
            return;
        }
        int update = this.storeMapper.updateById((Object)store);
        if (update > 0) {
            QueryWrapper agreementConfigWrapper = Wrappers.query();
            QueryWrapper channelConfigWrapper = Wrappers.query();
            QueryWrapper participantConfigWrapper = Wrappers.query();
            agreementConfigWrapper.eq((Object)"goods_store_id", (Object)store.getId());
            channelConfigWrapper.eq((Object)"goods_store_id", (Object)store.getId());
            participantConfigWrapper.eq((Object)"goods_store_id", (Object)store.getId());
            this.agreementConfigMapper.delete((Wrapper)agreementConfigWrapper);
            this.channelConfigMapper.delete((Wrapper)channelConfigWrapper);
            this.participantConfigMapper.delete((Wrapper)participantConfigWrapper);
        } else {
            this.save((Object)store);
            this.pictureStoreRepository.saveBatch(store.getPictures());
        }
        store.getAgreementCondition().forEach(arg_0 -> ((StoreAgreementConfigMapper)this.agreementConfigMapper).insert(arg_0));
        store.getParticipantCondition().forEach(arg_0 -> ((StoreParticipantConfigMapper)this.participantConfigMapper).insert(arg_0));
        store.getChannelCondition().forEach(arg_0 -> ((StoreChannelConfigMapper)this.channelConfigMapper).insert(arg_0));
    }

    public IPage<CommodityStoreVo> findByCondition(Pageable pageable, CommodityStoreQueryDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)30));
        dto = (CommodityStoreQueryDto)ObjectUtils.defaultIfNull((Object)dto, (Object)new CommodityStoreQueryDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.storeMapper.findByCondition((Page<CommodityStoreVo>)page, dto);
    }

    public IPage<MobileStoreVo> findAll(Pageable pageable, MobileStoreQueryDto dto) {
        if (null == dto) {
            return null;
        }
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)30));
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.storeMapper.findAll((Page<MobileStoreVo>)page, dto);
    }

    public MobileStoreVo findById(MobileStoreQueryDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getId())) {
            return null;
        }
        IPage<MobileStoreVo> all = this.findAll(null, dto);
        Validate.isFalse((boolean)CollectionUtils.isEmpty((Collection)all.getRecords()), (String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u5546\u54c1\u8bbf\u95ee\u6743\u9650");
        return (MobileStoreVo)all.getRecords().get(0);
    }
}

