/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.biz.crm.mall.commodity.local.entity.GoodsClassify;
import com.biz.crm.mall.commodity.local.mapper.GoodsClassifyMapper;
import com.biz.crm.mall.commodity.local.repository.CommodityClassificationRepository;
import com.biz.crm.mall.commodity.local.service.CommodityClassificationService;
import com.biz.crm.mall.commodity.sdk.constant.CommodityConstant;
import com.biz.crm.mall.commodity.sdk.dto.ChangeStatusDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationInsertDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationQueryDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationUpdateDto;
import com.biz.crm.mall.commodity.sdk.service.CommodityClassificationVoService;
import com.biz.crm.mall.commodity.sdk.vo.CommodityClassificationVo;
import com.biz.crm.mall.common.sdk.service.CodeService;
import com.biz.crm.mall.common.sdk.service.IdService;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class CommodityClassificationServiceImpl
implements CommodityClassificationService {
    private final CodeService codeService;
    private final IdService idService;
    private final GoodsClassifyMapper mapper;
    private final CommodityClassificationRepository repository;
    @Resource
    private CommodityClassificationVoService voService;

    public CommodityClassificationServiceImpl(CodeService codeService, IdService idService, GoodsClassifyMapper mapper, CommodityClassificationRepository repository) {
        this.codeService = codeService;
        this.idService = idService;
        this.mapper = mapper;
        this.repository = repository;
    }

    @Override
    public void save(CommodityClassificationInsertDto dto) {
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        boolean isParentIdEmpty = StringUtils.isBlank((CharSequence)dto.getParentId());
        this.checkDuplicate(dto.getName(), true);
        GoodsClassify classification = new GoodsClassify();
        classification.setId(this.idService.stringId());
        classification.setCode(this.codeService.generateCode("mall_classification"));
        classification.setName(dto.getName());
        classification.setType(isParentIdEmpty ? CommodityConstant.CLASSIFICATION_LEVEL_TOP : CommodityConstant.CLASSIFICATION_LEVEL_CHILD);
        classification.setParentId(isParentIdEmpty ? "0" : dto.getParentId());
        classification.setRemark(dto.getRemark());
        classification.setStatus(CommodityConstant.DISABLE);
        this.checkParentExist(classification.getParentId());
        this.checkDuplicate(classification.getCode(), true);
        this.mapper.insert((Object)classification);
    }

    @Override
    public void changeStatus(ChangeStatusDto dto) {
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u542f\u7981\u7528\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notNull((Object)dto.getStatus(), (String)"\u542f\u7981\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.isTrue((CommodityConstant.ENABLE.equals(dto.getStatus()) || CommodityConstant.DISABLE.equals(dto.getStatus()) ? 1 : 0) != 0, (String)"\u542f\u7981\u7528\u72b6\u6001\u9519\u8bef");
        GoodsClassify classify = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)classify), (String)"\u6ca1\u6709\u8be5\u5546\u54c1\u5206\u7c7b");
        Validate.isFalse((boolean)classify.getStatus().equals(dto.getStatus()), (String)"\u4e0d\u9700\u91cd\u590d\u542f\u7981\u7528");
        classify.setStatus(dto.getStatus());
        this.repository.updateById((Object)classify);
    }

    @Override
    public void enableBatch(List<ChangeStatusDto> dtos) {
        for (ChangeStatusDto dto : dtos) {
            Validate.isTrue((boolean)CommodityConstant.ENABLE.equals(dto.getStatus()), (String)"\u542f\u7528\u53c2\u6570\u9519\u8bef");
            this.changeStatus(dto);
        }
    }

    @Override
    public void disableBatch(List<ChangeStatusDto> dtos) {
        ArrayList<GoodsClassify> list = new ArrayList<GoodsClassify>(dtos.size());
        for (ChangeStatusDto dto : dtos) {
            Validate.isTrue((boolean)CommodityConstant.DISABLE.equals(dto.getStatus()), (String)"\u7981\u7528\u53c2\u6570\u9519\u8bef");
            GoodsClassify classify = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
            Validate.notNull((Object)((Object)classify), (String)"\u6ca1\u6709\u8be5\u5546\u54c1\u5206\u7c7b");
            CommodityClassificationQueryDto queryDto = new CommodityClassificationQueryDto();
            queryDto.setCodeOrName(classify.getCode());
            IPage page = this.voService.findByCondition((Pageable)PageRequest.of((int)1, (int)1000), queryDto);
            for (CommodityClassificationVo record : page.getRecords()) {
                if (!CommodityConstant.ENABLE.equals(record.getStatus())) continue;
                GoodsClassify goodsClassify = new GoodsClassify();
                goodsClassify.setId(record.getId());
                goodsClassify.setStatus(dto.getStatus());
                list.add(goodsClassify);
            }
        }
        this.repository.updateBatchById(list);
    }

    @Override
    public void enableOrDisable(List<ChangeStatusDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        if (CommodityConstant.DISABLE.equals(dtos.get(0).getStatus())) {
            this.disableBatch(dtos);
        } else {
            this.enableBatch(dtos);
        }
    }

    @Override
    public void update(CommodityClassificationUpdateDto dto) {
        Validate.notBlank((CharSequence)dto.getName(), (String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notBlank((CharSequence)dto.getId(), (String)"\u4fee\u6539\u5bf9\u8c61id\u4e0d\u80fd\u4e3a\u7a7a");
        boolean isParentIdEmpty = StringUtils.isEmpty((CharSequence)dto.getParentId());
        this.checkDuplicate(dto.getName(), false);
        GoodsClassify classification = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.isTrue((boolean)CommodityConstant.DISABLE.equals(classification.getStatus()), (String)"\u8bf7\u5148\u7981\u7528\u518d\u7f16\u8f91");
        classification.setName(dto.getName());
        classification.setType(isParentIdEmpty ? CommodityConstant.CLASSIFICATION_LEVEL_TOP : CommodityConstant.CLASSIFICATION_LEVEL_CHILD);
        classification.setParentId(isParentIdEmpty ? "0" : dto.getParentId());
        classification.setRemark(dto.getRemark());
        this.checkParentExist(classification.getParentId());
        Validate.isFalse((boolean)this.isChild(classification.getParentId(), classification.getId()), (String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u80fd\u662f\u4e0b\u5c5e\u5c42\u7ea7");
        this.repository.updateById((Object)classification);
    }

    private void checkDuplicate(String codeOrName, boolean isSave) {
        CommodityClassificationQueryDto classificationQueryDto = new CommodityClassificationQueryDto();
        classificationQueryDto.setCodeOrName(codeOrName);
        IPage<CommodityClassificationVo> repeat = this.repository.findByCondition(null, classificationQueryDto);
        if (isSave) {
            Validate.isTrue((0L == repeat.getTotal() ? 1 : 0) != 0, (String)"\u5206\u7c7b\u540d\u79f0\u6216\u7f16\u7801\u5df2\u5b58\u5728");
        } else {
            Validate.isTrue((0L == repeat.getTotal() || 1L == repeat.getTotal() && (((CommodityClassificationVo)repeat.getRecords().get(0)).getCode().equals(codeOrName) || ((CommodityClassificationVo)repeat.getRecords().get(0)).getName().equals(codeOrName)) ? 1 : 0) != 0, (String)"\u5206\u7c7b\u540d\u79f0\u6216\u7f16\u7801\u5df2\u5b58\u5728");
        }
    }

    public void checkParentExist(String parentId) {
        if ("0".equals(parentId)) {
            return;
        }
        GoodsClassify byId = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)parentId)));
        Validate.notNull((Object)((Object)byId), (String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728");
        Validate.isFalse((boolean)byId.getParentId().equalsIgnoreCase(parentId), (String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u80fd\u662f\u81ea\u5df1");
        Validate.isTrue((boolean)CommodityConstant.ENABLE.equals(byId.getStatus()), (String)"\u4e0a\u7ea7\u5206\u7c7b\u5fc5\u987b\u662f\u542f\u7528\u72b6\u6001");
    }

    public boolean isChild(String child, String parent) {
        Validate.isFalse((StringUtils.isBlank((CharSequence)child) || StringUtils.isBlank((CharSequence)parent) ? 1 : 0) != 0, (String)"\u672a\u77e5\u9519\u8bef");
        if (child.equals(parent)) {
            return false;
        }
        GoodsClassify p = (GoodsClassify)((Object)this.repository.getById((Serializable)((Object)parent)));
        CommodityClassificationQueryDto dto = new CommodityClassificationQueryDto();
        dto.setCodeOrName(p.getCode());
        IPage page = this.voService.findByCondition((Pageable)PageRequest.of((int)1, (int)100000), dto);
        if (page.getTotal() == 0L || CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return false;
        }
        return page.getRecords().stream().anyMatch(vo -> vo.getId().equals(child));
    }
}

