/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mall.commodity.local.mapper.GoodsClassifyMapper;
import com.biz.crm.mall.commodity.local.repository.CommodityClassificationRepository;
import com.biz.crm.mall.commodity.sdk.constant.CommodityConstant;
import com.biz.crm.mall.commodity.sdk.dto.CommodityClassificationQueryDto;
import com.biz.crm.mall.commodity.sdk.service.CommodityClassificationVoService;
import com.biz.crm.mall.commodity.sdk.vo.CommodityClassificationVo;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class CommodityClassificationVoServiceImpl
implements CommodityClassificationVoService {
    private final CommodityClassificationRepository repository;
    private final GoodsClassifyMapper mapper;

    public CommodityClassificationVoServiceImpl(CommodityClassificationRepository repository, GoodsClassifyMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }

    public IPage<CommodityClassificationVo> findByCondition(Pageable pageable, CommodityClassificationQueryDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getCodeOrName())) {
            return this.repository.findByCondition(pageable, dto);
        }
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dto.getId()), (String)"\u53c2\u6570\u9519\u8bef");
        List<CommodityClassificationVo> tree = this.findTreeByCondition(dto);
        CommodityClassificationVo root = new CommodityClassificationVo();
        root.setId("0");
        root.setChildren(tree);
        CommodityClassificationVo vo = new CommodityClassificationVo();
        this.walkTreeByCondition(root, dto.getCodeOrName(), vo);
        ArrayList<CommodityClassificationVo> list = new ArrayList<CommodityClassificationVo>();
        this.treeToList(vo, list);
        for (CommodityClassificationVo var : list) {
            var.getChildren().clear();
        }
        int pageNo = pageable.getPageNumber();
        int pageSize = pageable.getPageSize();
        int total = list.size();
        Page page = new Page((long)pageNo, (long)pageSize, (long)total);
        page.setRecords(list.subList((pageNo - 1) * pageSize, total - pageNo * pageSize > pageSize ? pageNo * pageSize + pageSize : total));
        return page;
    }

    public List<CommodityClassificationVo> findTreeByCondition(CommodityClassificationQueryDto dto) {
        List<CommodityClassificationVo> records = this.repository.findAll();
        if (CollectionUtils.isEmpty(records)) {
            return records;
        }
        if (null != dto && StringUtils.isNotBlank((CharSequence)dto.getCodeOrName())) {
            List list = records.stream().filter(vo -> dto.getCodeOrName().equals(vo.getCode()) || vo.getName().contains(dto.getCodeOrName())).collect(Collectors.toList());
            ArrayList<CommodityClassificationVo> result = new ArrayList<CommodityClassificationVo>();
            result.addAll(list);
            for (CommodityClassificationVo vo2 : list) {
                this.findParent(vo2, records, result);
            }
            records = result;
        }
        CommodityClassificationVo parent = new CommodityClassificationVo();
        parent.setId("0");
        parent.setChildren(new ArrayList());
        this.makeUpTree(records, parent);
        return parent.getChildren();
    }

    public CommodityClassificationVo findById(String id) {
        return this.repository.findById(id);
    }

    public List<CommodityClassificationVo> findList() {
        return this.mapper.findAll().stream().filter(vo -> CommodityConstant.ENABLE.equals(vo.getStatus())).collect(Collectors.toList());
    }

    public List<CommodityClassificationVo> findRoots() {
        return this.mapper.findAll().stream().filter(vo -> "0".equals(vo.getParentId())).filter(vo -> vo.getStatus().equals(CommodityConstant.ENABLE)).collect(Collectors.toList());
    }

    private void makeUpTree(List<CommodityClassificationVo> records, CommodityClassificationVo parent) {
        ArrayList<CommodityClassificationVo> temp = new ArrayList<CommodityClassificationVo>();
        temp.addAll(records);
        for (int i = 0; i < records.size(); ++i) {
            if (!records.get(i).getParentId().equals(parent.getId())) continue;
            parent.getChildren().add(records.get(i));
            temp.remove(records.get(i));
            this.makeUpTree(temp, records.get(i));
        }
    }

    private void walkTreeByCondition(CommodityClassificationVo parent, String codeOrName, CommodityClassificationVo result) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            if (((CommodityClassificationVo)parent.getChildren().get(i)).getCode().equals(codeOrName) || ((CommodityClassificationVo)parent.getChildren().get(i)).getName().contains(codeOrName)) {
                result.getChildren().add(parent.getChildren().get(i));
            }
            this.walkTreeByCondition((CommodityClassificationVo)parent.getChildren().get(i), codeOrName, result);
        }
    }

    private void treeToList(CommodityClassificationVo tree, List<CommodityClassificationVo> list) {
        for (CommodityClassificationVo child : tree.getChildren()) {
            list.add(child);
            this.treeToList(child, list);
        }
    }

    private void findParent(CommodityClassificationVo node, List<CommodityClassificationVo> resource, List<CommodityClassificationVo> result) {
        if ("0".equals(node.getParentId())) {
            return;
        }
        resource.stream().filter(vo -> vo.getId().equals(node.getParentId())).findAny().ifPresent(vo -> {
            if (!result.contains(vo)) {
                result.add((CommodityClassificationVo)vo);
            }
            this.findParent((CommodityClassificationVo)vo, resource, result);
        });
    }
}

