/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.mall.commodity.local.entity.GoodsBase;
import com.biz.crm.mall.commodity.local.entity.GoodsPicture;
import com.biz.crm.mall.commodity.local.entity.GoodsStore;
import com.biz.crm.mall.commodity.local.entity.GoodsVirtualInfo;
import com.biz.crm.mall.commodity.local.entity.StoreAgreementConfig;
import com.biz.crm.mall.commodity.local.entity.StoreChannelConfig;
import com.biz.crm.mall.commodity.local.entity.StoreParticipantConfig;
import com.biz.crm.mall.commodity.local.entity.StorePicture;
import com.biz.crm.mall.commodity.local.mapper.GoodsStoreMapper;
import com.biz.crm.mall.commodity.local.repository.CommodityRepository;
import com.biz.crm.mall.commodity.local.repository.CommodityStoreRepository;
import com.biz.crm.mall.commodity.local.repository.CommodityVirtualRepository;
import com.biz.crm.mall.commodity.local.repository.PictureCommodityRepository;
import com.biz.crm.mall.commodity.local.repository.PictureStoreRepository;
import com.biz.crm.mall.commodity.local.service.CommodityStoreService;
import com.biz.crm.mall.commodity.sdk.constant.CommodityConstant;
import com.biz.crm.mall.commodity.sdk.dto.StoreDeductDto;
import com.biz.crm.mall.commodity.sdk.dto.StoreSaveDto;
import com.biz.crm.mall.commodity.sdk.service.CommodityStoreSdkService;
import com.biz.crm.mall.common.sdk.service.IdService;
import com.biz.crm.mall.common.sdk.service.LoginUserService;
import com.biz.crm.mall.common.sdk.util.Validate;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class CommodityStoreServiceImpl
implements CommodityStoreService,
CommodityStoreSdkService {
    private final CommodityStoreRepository repository;
    private final GoodsStoreMapper mapper;
    private final CommodityRepository commodityRepository;
    private final IdService idService;
    private final LoginUserService userService;
    private final CommodityVirtualRepository virtualRepository;
    private final PictureCommodityRepository pictureCommodityRepository;
    private final PictureStoreRepository pictureStoreRepository;

    public CommodityStoreServiceImpl(CommodityStoreRepository repository, GoodsStoreMapper mapper, CommodityRepository commodityRepository, IdService idService, LoginUserService userService, CommodityVirtualRepository virtualRepository, PictureCommodityRepository pictureCommodityRepository, PictureStoreRepository pictureStoreRepository) {
        this.repository = repository;
        this.mapper = mapper;
        this.commodityRepository = commodityRepository;
        this.idService = idService;
        this.userService = userService;
        this.virtualRepository = virtualRepository;
        this.pictureCommodityRepository = pictureCommodityRepository;
        this.pictureStoreRepository = pictureStoreRepository;
    }

    @Override
    public void onSale(StoreSaveDto dto) {
        boolean isNew = StringUtils.isBlank((CharSequence)dto.getId());
        Validate.notNull((Object)dto.getGoodsCode(), (String)"\u4e0a\u67b6\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.notNull((Object)dto.getQuantity(), (String)"\u4e0a\u67b6\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        Validate.isTrue((0L <= dto.getQuantity() ? 1 : 0) != 0, (String)"\u4e0a\u67b6\u6570\u91cf\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        LocalDate now = LocalDate.now();
        Date date = Date.from(now.atStartOfDay(ZoneOffset.ofHours(8)).toInstant());
        if (null == dto.getStartTime() || null == dto.getEndTime()) {
            dto.setStartTime(new Date());
            dto.setEndTime(Date.from(LocalDate.of(2099, 1, 1).atStartOfDay(ZoneOffset.ofHours(8)).toInstant()));
        }
        Validate.isTrue((boolean)dto.getStartTime().after(date), (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u8fc7\u53bb\u7684\u65f6\u95f4");
        Validate.isTrue((boolean)dto.getStartTime().before(dto.getEndTime()), (String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4");
        dto.setAgreementConditions((Set)ObjectUtils.defaultIfNull((Object)dto.getAgreementConditions(), new HashSet(0)));
        dto.setParticipantConditions((Set)ObjectUtils.defaultIfNull((Object)dto.getParticipantConditions(), new HashSet(0)));
        dto.setChannelConditions((Set)ObjectUtils.defaultIfNull((Object)dto.getChannelConditions(), new HashSet(0)));
        GoodsBase commodity = this.commodityRepository.findByCode(dto.getGoodsCode());
        Validate.isTrue((boolean)CommodityConstant.ENABLE.equals(commodity.getStatus()), (String)"\u53ea\u80fd\u4e0a\u67b6\u5df2\u542f\u7528\u7684\u5546\u54c1");
        this.checkCommodityIfSelling(commodity.getId());
        if (isNew) {
            this.save(dto, commodity);
        } else {
            this.update(dto);
        }
    }

    @Override
    public void noSale(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8bf7\u9009\u62e9\u4e0a\u67b6\u5546\u54c1");
        GoodsStore store = (GoodsStore)((Object)this.repository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)store), (String)"\u6ca1\u6709\u8be5\u4e0a\u67b6\u5546\u54c1");
        if (CommodityConstant.COMMODITY_NO_SALE.equals(store.getStatus())) {
            return;
        }
        store.setStatus(CommodityConstant.COMMODITY_NO_SALE);
        GoodsBase commodity = (GoodsBase)((Object)this.commodityRepository.getById((Serializable)((Object)store.getGoodsId())));
        store.setCode(commodity.getCode());
        store.setName(commodity.getName());
        store.setDetails(commodity.getDetails());
        store.setType(commodity.getType());
        store.setPrice(commodity.getPrice());
        store.setClassId(commodity.getClassId());
        List<GoodsPicture> goodsPictureList = this.pictureCommodityRepository.findByGoodsId(commodity.getId());
        store.setPictures(goodsPictureList.stream().map(p -> {
            StorePicture storePicture = new StorePicture();
            storePicture.setId(this.idService.stringId());
            storePicture.setGoodsStoreId(store.getId());
            storePicture.setUrl(p.getUrl());
            storePicture.setType(p.getType());
            return storePicture;
        }).collect(Collectors.toList()));
        QueryWrapper pictureStoreRepositoryQueryWrapper = Wrappers.query();
        this.pictureStoreRepository.remove((Wrapper)pictureStoreRepositoryQueryWrapper);
        this.pictureStoreRepository.saveBatch(store.getPictures());
        this.repository.updateById((Object)store);
    }

    public void deduct(StoreDeductDto dto) {
        GoodsStore store = (GoodsStore)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)store), (String)"\u4e0a\u67b6\u5546\u54c1\u4e0d\u5b58\u5728");
        Validate.isTrue((boolean)CommodityConstant.COMMODITY_ON_SALE.equals(store.getStatus()), (String)"\u5546\u54c1\u672a\u4e0a\u67b6\uff0c\u65e0\u6cd5\u6263\u51cf\u5e93\u5b58");
        Validate.isTrue((boolean)new Date().before(store.getEndTime()), (String)"\u5546\u54c1\u5df2\u8fc7\u671f");
        Validate.isTrue((dto.getQuantity() != null && dto.getQuantity() > 0L ? 1 : 0) != 0, (String)"\u6263\u51cf\u6570\u91cf\u6709\u8bef");
        store.setRemainder(store.getRemainder() - dto.getQuantity());
        Validate.isTrue((store.getRemainder() >= 0L ? 1 : 0) != 0, (String)"\u5e93\u5b58\u4e0d\u8db3");
        if (store.getRemainder() == 0L) {
            store.setStatus(CommodityConstant.COMMODITY_NO_SALE);
        }
        store.setTotalSold(store.getTotalSold() + dto.getQuantity());
        if (CommodityConstant.COMMODITY_TYPE_VIRTUAL.equals(store.getType())) {
            store.setVirtualCardDischarge(store.getVirtualCardDischarge() + dto.getQuantity());
        }
        this.repository.updateById((Object)store);
    }

    public void deduct(List<StoreDeductDto> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            return;
        }
        dtos.forEach(this::deduct);
    }

    @Override
    public void onSale(List<StoreSaveDto> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(this::onSale);
    }

    @Override
    public void noSale(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ids.forEach(this::noSale);
    }

    public List<String> releaseVirtualCard(String commodityId, Long quantity) {
        if (commodityId == null || quantity == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> re = new ArrayList<String>();
        Long validQuantity = this.virtualRepository.validQuantity(commodityId);
        Validate.isTrue((validQuantity > quantity ? 1 : 0) != 0, (String)"\u5361\u5238\u6570\u91cf\u4e0d\u8db3");
        List<GoodsVirtualInfo> list = this.virtualRepository.findValidByCommodityId(commodityId);
        ArrayList<GoodsVirtualInfo> update = new ArrayList<GoodsVirtualInfo>();
        int i = 0;
        while ((long)i < quantity) {
            re.add(list.get(i).getId());
            list.get(i).setIssue(CommodityConstant.VIRTUAL_RELEASE_YES);
            update.add(list.get(i));
            ++i;
        }
        this.virtualRepository.updateBatchById(update);
        return re;
    }

    public void save(StoreSaveDto dto, GoodsBase commodity) {
        GoodsStore store = new GoodsStore();
        store.setId(this.idService.stringId());
        store.setGoodsId(commodity.getId());
        store.setTotalOnSale(dto.getQuantity());
        store.setTotalSold(0L);
        store.setRemainder(dto.getQuantity());
        Long validQuantity = this.virtualRepository.validQuantity(commodity.getId());
        Validate.isTrue((CommodityConstant.COMMODITY_TYPE_REAL.equals(commodity.getType()) || validQuantity.compareTo(store.getRemainder()) >= 0 ? 1 : 0) != 0, (String)"\u5269\u4f59\u5361\u5238\u6570\u91cf\u4e0d\u8db3");
        store.setStatus(CommodityConstant.COMMODITY_ON_SALE);
        store.setStartTime(dto.getStartTime());
        store.setEndTime(dto.getEndTime());
        store.setVirtualCardDischarge(0L);
        store.setCreateAccount(this.userService.getLoginAccountName());
        store.setCreateTime(new Date());
        store.setChannelCondition(new HashSet<StoreChannelConfig>());
        store.setAgreementCondition(new HashSet<StoreAgreementConfig>());
        store.setParticipantCondition(new HashSet<StoreParticipantConfig>());
        store.setCode(commodity.getCode());
        store.setName(commodity.getName());
        store.setDetails(commodity.getDetails());
        store.setType(commodity.getType());
        store.setPrice(commodity.getPrice());
        store.setClassId(commodity.getClassId());
        List<GoodsPicture> goodsPictureList = this.pictureCommodityRepository.findByGoodsId(commodity.getId());
        store.setPictures(goodsPictureList.stream().map(p -> {
            StorePicture storePicture = new StorePicture();
            storePicture.setId(this.idService.stringId());
            storePicture.setGoodsStoreId(store.getId());
            storePicture.setUrl(p.getUrl());
            storePicture.setType(p.getType());
            return storePicture;
        }).collect(Collectors.toList()));
        dto.getParticipantConditions().forEach(str -> {
            StoreParticipantConfig participantConfig = new StoreParticipantConfig();
            participantConfig.setId(this.idService.stringId());
            participantConfig.setGoodsStoreId(store.getId());
            participantConfig.setParticipantCode((String)str);
            store.getParticipantCondition().add(participantConfig);
        });
        dto.getChannelConditions().forEach(str -> {
            StoreChannelConfig channelConfig = new StoreChannelConfig();
            channelConfig.setId(this.idService.stringId());
            channelConfig.setGoodsStoreId(store.getId());
            channelConfig.setChannelCode((String)str);
            store.getChannelCondition().add(channelConfig);
        });
        dto.getAgreementConditions().forEach(vo -> {
            StoreAgreementConfig agreementConfig = new StoreAgreementConfig();
            agreementConfig.setId(this.idService.stringId());
            agreementConfig.setGoodsStoreId(store.getId());
            agreementConfig.setAgreementCode(vo.getCode());
            agreementConfig.setAgreementName(vo.getName());
            store.getAgreementCondition().add(agreementConfig);
        });
        this.repository.store(store);
    }

    public void update(StoreSaveDto dto) {
        GoodsStore store = (GoodsStore)((Object)this.repository.getById((Serializable)((Object)dto.getId())));
        Validate.isTrue((dto.getQuantity().compareTo(store.getTotalSold()) > 0 ? 1 : 0) != 0, (String)"\u7d2f\u8ba1\u4e0a\u67b6\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e\u7d2f\u8ba1\u5151\u6362\u6570\u91cf");
        Long validQuantity = this.virtualRepository.validQuantity(store.getGoodsId());
        store.setTotalOnSale(dto.getQuantity());
        store.setRemainder(dto.getQuantity() - store.getTotalSold());
        Validate.isTrue((CommodityConstant.COMMODITY_TYPE_REAL.equals(store.getType()) || validQuantity.compareTo(store.getRemainder()) >= 0 ? 1 : 0) != 0, (String)"\u5269\u4f59\u5361\u5238\u6570\u91cf\u4e0d\u8db3");
        store.setStartTime(dto.getStartTime());
        store.setEndTime(dto.getEndTime());
        store.setStatus(CommodityConstant.COMMODITY_ON_SALE);
        store.setUpdateAccount(this.userService.getLoginAccountName());
        store.setUpdateTime(new Date());
        store.setAgreementCondition(Sets.newHashSet());
        store.setParticipantCondition(Sets.newHashSet());
        store.setChannelCondition(Sets.newHashSet());
        dto.getParticipantConditions().forEach(str -> {
            StoreParticipantConfig participantConfig = new StoreParticipantConfig();
            participantConfig.setId(this.idService.stringId());
            participantConfig.setGoodsStoreId(store.getId());
            participantConfig.setParticipantCode((String)str);
            store.getParticipantCondition().add(participantConfig);
        });
        dto.getChannelConditions().forEach(str -> {
            StoreChannelConfig channelConfig = new StoreChannelConfig();
            channelConfig.setId(this.idService.stringId());
            channelConfig.setGoodsStoreId(store.getId());
            channelConfig.setChannelCode((String)str);
            store.getChannelCondition().add(channelConfig);
        });
        dto.getAgreementConditions().forEach(vo -> {
            StoreAgreementConfig agreementConfig = new StoreAgreementConfig();
            agreementConfig.setId(this.idService.stringId());
            agreementConfig.setGoodsStoreId(store.getId());
            Validate.notBlank((CharSequence)vo.getCode(), (String)"\u534f\u8bae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Validate.notBlank((CharSequence)vo.getName(), (String)"\u534f\u8bae\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            agreementConfig.setAgreementCode(vo.getCode());
            agreementConfig.setAgreementName(vo.getName());
            store.getAgreementCondition().add(agreementConfig);
        });
        this.repository.store(store);
    }

    private void checkCommodityIfSelling(String commodityId) {
        GoodsStore store = new GoodsStore();
        store.setGoodsId(commodityId);
        store.setStatus(CommodityConstant.COMMODITY_ON_SALE);
        List<GoodsStore> list = this.repository.findByCondition(store);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(list), (String)"\u5f53\u524d\u5546\u54c1\u5df2\u4e0a\u67b6\uff0c\u8bf7\u5148\u4e0b\u67b6");
    }
}

