/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mall.commodity.local.feign.AgreementFeign;
import com.biz.crm.mall.commodity.local.repository.CommodityStoreRepository;
import com.biz.crm.mall.commodity.sdk.dto.CommodityStoreQueryDto;
import com.biz.crm.mall.commodity.sdk.dto.CpsAgreementDto;
import com.biz.crm.mall.commodity.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.mall.commodity.sdk.dto.MobileStoreQueryDto;
import com.biz.crm.mall.commodity.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.mall.commodity.sdk.service.CommodityStoreVoService;
import com.biz.crm.mall.commodity.sdk.vo.AgreementTemplateVo;
import com.biz.crm.mall.commodity.sdk.vo.AgreementVo;
import com.biz.crm.mall.commodity.sdk.vo.CommodityStoreVo;
import com.biz.crm.mall.commodity.sdk.vo.CpsAgreementVo;
import com.biz.crm.mall.commodity.sdk.vo.MobileStoreVo;
import com.biz.crm.mall.common.sdk.service.LoginUserService;
import com.biz.crm.mall.common.sdk.util.Validate;
import com.biz.crm.mall.common.sdk.vo.LoginUserDetails;
import com.biz.crm.mall.common.sdk.vo.Result;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.mdm.terminal.MdmTerminalFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class CommodityStoreVoServiceImpl
implements CommodityStoreVoService {
    private final CommodityStoreRepository repository;
    private final LoginUserService userService;
    private final AgreementFeign agreementFeign;
    private final MdmCustomerMsgFeign customerMsgFeign;
    private final MdmTerminalFeign terminalFeign;

    public CommodityStoreVoServiceImpl(CommodityStoreRepository repository, LoginUserService userService, @Qualifier(value="AgreementFeign") AgreementFeign agreementFeign, @Qualifier(value="MdmCustomerMsgFeign") MdmCustomerMsgFeign customerMsgFeign, MdmTerminalFeign terminalFeign) {
        this.repository = repository;
        this.userService = userService;
        this.agreementFeign = agreementFeign;
        this.customerMsgFeign = customerMsgFeign;
        this.terminalFeign = terminalFeign;
    }

    public IPage<CommodityStoreVo> findByCondition(Pageable pageable, CommodityStoreQueryDto dto) {
        return this.repository.findByCondition(pageable, dto);
    }

    public IPage<MobileStoreVo> findAll(Pageable pageable, String name, String classId) {
        LoginUserDetails user = this.userService.currentUser();
        System.out.println(user.getUsertype());
        LoginUserAgreementDto q = new LoginUserAgreementDto();
        q.setAgreementStatus("1");
        Result<List<AgreementVo>> agreementDto = this.agreementFeign.findByLoginUserAgreementDto("1", null, null, null, null, null);
        System.out.println("agreementDto" + agreementDto.toString());
        ArrayList agreementCodes = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)((Collection)agreementDto.getResult()))) {
            ((List)agreementDto.getResult()).forEach(vo -> agreementCodes.add(vo.getTemplateCode()));
        }
        MobileStoreQueryDto dto = new MobileStoreQueryDto();
        if ("terminal".equals(user.getUsertype())) {
            dto.setParticipantCode("2");
            com.biz.crm.util.Result result = this.terminalFeign.query(null, user.getConsumerCode());
            System.out.println("terminal" + result.toString());
            if (null != result.getResult()) {
                dto.setChannelCode(((MdmTerminalVo)result.getResult()).getChannel());
            }
        } else if ("customer_employee".equals(user.getUsertype())) {
            dto.setParticipantCode("1");
            MdmCustomerMsgRespVo result = (MdmCustomerMsgRespVo)this.customerMsgFeign.query(null, user.getConsumerCode()).getResult();
            System.out.println("customer_employee" + result.toString());
            if (null != result) {
                dto.setChannelCode(result.getChannel());
            }
        }
        dto.setAgreementCodeList(agreementCodes);
        dto.setName(name);
        dto.setClassId(classId);
        return this.repository.findAll(pageable, dto);
    }

    public MobileStoreVo findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8bf7\u9009\u62e9\u5546\u54c1");
        LoginUserDetails user = this.userService.currentUser();
        LoginUserAgreementDto q = new LoginUserAgreementDto();
        q.setAgreementStatus("1");
        Result<List<AgreementVo>> agreementDto = this.agreementFeign.findByLoginUserAgreementDto("1", null, null, null, null, null);
        ArrayList agreementCodes = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)((Collection)agreementDto.getResult()))) {
            ((List)agreementDto.getResult()).forEach(vo -> agreementCodes.add(vo.getAgreementCode()));
        }
        MobileStoreQueryDto dto = new MobileStoreQueryDto();
        dto.setId(id);
        if ("terminal".equals(user.getUsertype())) {
            dto.setParticipantCode("2");
            com.biz.crm.util.Result result = this.terminalFeign.query(null, user.getConsumerCode());
            if (null != result.getResult()) {
                dto.setChannelCode(((MdmTerminalVo)result.getResult()).getChannel());
            }
        } else if ("customer_employee".equals(user.getUsertype())) {
            dto.setParticipantCode("1");
            MdmCustomerMsgRespVo result = (MdmCustomerMsgRespVo)this.customerMsgFeign.query(null, user.getConsumerCode()).getResult();
            if (null != result) {
                dto.setChannelCode(result.getChannel());
            }
        }
        dto.setAgreementCodeList(agreementCodes);
        return this.repository.findById(dto);
    }

    public Page<CpsAgreementVo> findByCondition(Pageable pageable, CpsAgreementDto dto) {
        ProfitAgreementTemplatePaginationDto dto1 = new ProfitAgreementTemplatePaginationDto();
        dto1.setTemplateCode(dto.getCode());
        dto1.setTemplateName(dto.getName());
        dto1.setOrgCode(dto.getOrg());
        dto1.setChannelCode(dto.getChannel());
        dto1.setPolicyCode(dto.getPolicy());
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("page", pageable.getPageNumber());
        map.put("size", pageable.getPageSize());
        Result<Page<AgreementTemplateVo>> result = this.agreementFeign.findByConditions(map, dto1);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize(), 0L);
        ArrayList list = new ArrayList();
        if (null == result.getResult()) {
            return page;
        }
        ((Page)result.getResult()).getRecords().forEach(vo -> {
            CpsAgreementVo cpsAgreementVo = new CpsAgreementVo();
            cpsAgreementVo.setCode(vo.getTemplateCode());
            cpsAgreementVo.setName(vo.getTemplateName());
            cpsAgreementVo.setOrg(vo.getTemplateOrgNameStr());
            cpsAgreementVo.setChannel(vo.getTemplateChannelNameStr());
            cpsAgreementVo.setPolicy(Arrays.stream(vo.getTemplatePolicyNameStr().split(",")).collect(Collectors.toList()));
            list.add(cpsAgreementVo);
        });
        page.setRecords(list).setCurrent(((Page)result.getResult()).getCurrent()).setTotal(((Page)result.getResult()).getTotal()).setSize(((Page)result.getResult()).getSize());
        return page;
    }
}

