/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.internal;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.biz.crm.mall.commodity.local.mapper.GoodsBaseMapper;
import com.biz.crm.mall.commodity.local.repository.CommodityRepository;
import com.biz.crm.mall.commodity.sdk.dto.CommodityQueryDto;
import com.biz.crm.mall.commodity.sdk.service.CommodityVoService;
import com.biz.crm.mall.commodity.sdk.vo.CommodityVo;
import com.biz.crm.mall.common.sdk.util.Validate;
import java.util.Collection;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(rollbackFor={RuntimeException.class})
public class CommodityVoServiceImpl
implements CommodityVoService {
    private final CommodityRepository repository;
    private final GoodsBaseMapper mapper;

    public CommodityVoServiceImpl(CommodityRepository repository, GoodsBaseMapper mapper) {
        this.repository = repository;
        this.mapper = mapper;
    }

    public IPage<CommodityVo> findByCondition(Pageable pageable, CommodityQueryDto dto) {
        return this.repository.findByCondition(pageable, dto);
    }

    public CommodityVo findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u67e5\u8be2\u5546\u54c1\u53c2\u6570\u9519\u8bef");
        CommodityQueryDto dto = new CommodityQueryDto();
        dto.setId(id);
        IPage<CommodityVo> page = this.repository.findByCondition(null, dto);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return null;
        }
        Validate.isTrue((1 == page.getRecords().size() ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u636e\u9519\u8bef");
        return (CommodityVo)page.getRecords().get(0);
    }

    public IPage<CommodityVo> findSaleByCondition(Pageable pageable, CommodityQueryDto dto) {
        return this.repository.findSaleByCondition(pageable, dto);
    }
}

