/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mall.commodity.local.service.listener;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import com.biz.crm.mall.commodity.local.service.CommodityService;
import com.biz.crm.mall.commodity.sdk.constant.CommodityConstant;
import com.biz.crm.mall.commodity.sdk.dto.CommodityDto;
import com.biz.crm.mall.commodity.sdk.dto.CommodityVirtualDto;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualCardsExcelListener
extends AnalysisEventListener<CommodityVirtualDto> {
    private static final Logger log = LoggerFactory.getLogger(VirtualCardsExcelListener.class);
    private static final int BATCH_COUNT = 3000;
    List<CommodityVirtualDto> list = new ArrayList<CommodityVirtualDto>();
    private final CommodityService service;
    private final CommodityDto dto;

    public VirtualCardsExcelListener(CommodityService service, CommodityDto dto) {
        this.service = service;
        this.dto = dto;
    }

    public void invoke(CommodityVirtualDto data, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString((Object)data));
        data.setCode("\u65e0");
        data.setIssue(CommodityConstant.VIRTUAL_RELEASE_NO);
        this.list.add(data);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
        this.service.saveOrUpdateWithCards(this.dto, this.list.toArray(new CommodityVirtualDto[0]));
    }
}

