package com.biz.crm.mdm.business.qywx.synchronize.sdk.dto;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.business.common.sdk.dto.UuidOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

@Data
@ApiModel("企微二次登录验证配置分页查询Dto")
public class LoginVerificationConfigPaginationDto extends UuidOpDto {


  @ApiModelProperty("人员类型编码")
  private String userTypeCode;

  @ApiModelProperty("人员类型名称")
  private String userTypeName;

  @ApiModelProperty("是否开启验证")
  private Boolean enable;

  @ApiModelProperty("创建时间小于于等于")
  @JsonFormat(
          locale = "zh",
          timezone = "GMT+8",
          pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
          pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date startTime;

  @ApiModelProperty("创建时间大于等于")
  @JsonFormat(
          locale = "zh",
          timezone = "GMT+8",
          pattern = "yyyy-MM-dd HH:mm:ss"
  )
  @DateTimeFormat(
          pattern = "yyyy-MM-dd HH:mm:ss"
  )
  private Date endTime;
}
