package com.biz.crm.mdm.business.qywx.synchronize.sdk.enums;

/**
 * 客户群变更事件类型
 *
 */
public enum ExternalChatChangeTypeEnum {

  CREATE("create", "客户群创建"),
  UPDATE("update", "客户群变更"),
  DISMISS("del_external_contact", "客户群解散");


  /**
   * 编码
   */
  private String code;

  /**
   * 说明
   */
  private String value;

  ExternalChatChangeTypeEnum(String code, String value) {
    this.code = code;
    this.value = value;
  }

  /**
   * 根据code转枚举
   *
   * @param code
   * @return
   */
  public static ExternalChatChangeTypeEnum codeToEnum(String code) {
    ExternalChatChangeTypeEnum result = null;
    for (ExternalChatChangeTypeEnum productLevelEnum : ExternalChatChangeTypeEnum.values()) {
      if (productLevelEnum.code.equals(code)) {
        result = productLevelEnum;
      }
    }
    return result;
  }

  public String getCode() {
    return code;
  }

  public String getValue() {
    return value;
  }
}
