package com.biz.crm.mdm.business.qywx.synchronize.sdk.enums;

/**
 * 客户变更事件类型
 *
 */
public enum ExternalContactChangeTypeEnum {

  ADD_EXTERNAL_CONTACT("add_external_contact", "新增客户"),
  EDIT_EXTERNAL_CONTACT("edit_external_contact", "编辑客户"),
  DEL_EXTERNAL_CONTACT("del_external_contact", "删除客户"),
  DEL_FOLLOW_USER("del_follow_user", "删除跟进成员"),
  TRANSFER_FAIL("transfer_fail", "客户接替失败");


  /**
   * 编码
   */
  private String code;

  /**
   * 说明
   */
  private String value;

  ExternalContactChangeTypeEnum(String code, String value) {
    this.code = code;
    this.value = value;
  }

  /**
   * 根据code转枚举
   *
   * @param code
   * @return
   */
  public static ExternalContactChangeTypeEnum codeToEnum(String code) {
    ExternalContactChangeTypeEnum result = null;
    for (ExternalContactChangeTypeEnum productLevelEnum : ExternalContactChangeTypeEnum.values()) {
      if (productLevelEnum.code.equals(code)) {
        result = productLevelEnum;
      }
    }
    return result;
  }

  public String getCode() {
    return code;
  }

  public String getValue() {
    return value;
  }
}
