package com.biz.crm.mdm.business.qywx.synchronize.sdk.enums;

/**
 * 客户/客户群变更事件
 */
public enum TerminalTypeEnum {

  CWQD_CT_MA("cwqd_ct_ma", "MA店", "门店类型MA店，门店面积≥200平米，＜1000平米"),
  CWQD_CT_20("cwqd_ct_20", "20店", "门店类型20店，门店面积＜200平米"),
  CWQD_CT_80("cwqd_ct_80", "大80店", "门店类型大80店，门店面积＜200平米"),
  CWQD_CT_SZ("cwqd_ct_sz", "食杂店", "门店类型食杂店，门店面积＜200平米"),
  CWQD_CT_QDHC("cwqd_ct_qdhc", "前店后仓", "门店类型前店后仓，门店面积＜200平米"),
  CWQD_CT_JPZY("cwqd_ct_jpzy", "竞品专营", "门店类型竞品专营，门店面积＜200平米"),
  CWQD_CT_ZJZM("cwqd_ct_zjzm", "MN自建专卖", "门店类型MN自建专卖，门店面积＜200平米"),
  CWQD_CT_PF("cwqd_ct_pf", "批发", "门店类型批发，门店面积＜200平米"),
  CWQD_CT_NCYHD("cwqd_ct_ncyhd", "农村一号店", "门店类型配送站，门店面积＜200平米"),
  CWQD_XD_NKA("cwqd_xd_nka", "现代渠道-NKA系统", "门店类型现代渠道-NKA系统，门店面积≥6000平米时为大卖场＜6000平米，≥1000时为大型超市＜1000平米，≥300时为中小型超市＜300平米时为便利店（CSV）"),
  CWQD_JY_XY("cwqd_jy_xy", "校园", "门店类型校园，门店面积＜200平米"),
  CWQD_XD_RKA("cwqd_xd_rka", "现代渠道-RKA系统", "门店类型现代渠道-RKA系统，门店面积≥6000平米时为大卖场＜6000平米，≥1000时为大型超市＜1000平米，≥300时为中小型超市＜300平米时为便利店（CSV）"),
  CWQD_XD_LKA("cwqd_xd_lka", "现代渠道-LKA系统", "门店类型现代渠道-LKA系统，门店面积≥6000平米时为大卖场＜6000平米，≥1000时为大型超市＜1000平米，≥300时为中小型超市＜300平米时为便利店（CSV）"),
  CWQD_XD_CVS("cwqd_xd_cvs", "现代渠道-CVS", "门店类型现代渠道-CVS，门店面积＜300平米"),
  CWQD_XD_XLS("cwqd_xd_xls", "现代渠道-新零售", "门店类型现代渠道-新零售，门店面积≥6000平米时为大卖场＜6000平米，≥1000时为大型超市＜1000平米，≥300时为中小型超市＜300平米时为便利店（CSV）"),
  CWQD_JY_MBF("cwqd_jy_mbf", "面包房", "门店类型面包房，门店面积＜200平米"),
  CWQD_JY_ZCD("cwqd_jy_zcd", "早餐店", "门店类型早餐店，门店面积＜200平米"),
  CWQD_TT_QT("cwqd_tt_qt", "特通-其他", "门店类型特通-其他，无平米限制"),
  CWQD_CT_XZC("cwqd_ct_xzc", "县镇村", "门店类型为县镇村，门店面积<1000平米"),
  CWQD_TT_XSN("cwqd_tt_xsn", "学生奶", "门店类型为学生奶，门店面积<1000平米"),
  CWQD_JY_ZFJ("cwqd_jy_zfj", "自贩机", "门店类型为自贩机，门店面积>10平米"),
  CWQD_JY_WRBLD("cwqd_jy_wrbld", "无人便利店", "门店类型为无人便利店，门店面积≥40平米"),
  CWQD_CT_XLS("cwqd_ct_xls", "传统渠道-新零售", "门店类型为传统渠道-新零售，门店面积≥40平米"),
  CWQD_TT_BTBCY("cwqd_tt_btbcy", "B2B餐饮", "门店类型为B2B餐饮，门店面积>0平米"),
  CWQD_TT_DZCY("cwqd_tt_dzcy", "大众餐饮", "门店类型为大众餐饮，门店面积>0平米"),
  CWQD_TT_GL("cwqd_tt_gl", "公路", "门店类型为公路，门店面积>0平米"),
  CWQD_TT_HK("cwqd_tt_hk", "航空", "门店类型为航空，门店面积>0平米"),
  CWQD_TT_HPCY("cwqd_tt_hpcy", "烘焙冲饮", "门店类型为烘焙冲饮，门店面积>0平米"),
  CWQD_TT_JUD("cwqd_tt_jud", "酒店", "门店类型为烘酒店，门店面积>0平米"),
  CWQD_TT_JD("cwqd_tt_jd", "军队", "门店类型为军队，门店面积>0平米"),
  CWQD_TT_LSSGCS("cwqd_tt_lssgcs", "连锁水果超市", "门店类型为连锁水果超市，门店面积>0平米"),
  CWQD_TT_MY("cwqd_tt_my", "母婴", "门店类型为母婴，门店面积>0平米"),
  CWQD_TT_TL("cwqd_tt_tl", "铁路", "门店类型为铁路，门店面积>0平米"),
  CWQD_TT_XLS("cwqd_tt_xls", "新零售", "门店类型为新零售，门店面积>0平米"),
  CWQD_TT_YL("cwqd_tt_yl", "医疗", "门店类型为医疗，门店面积>0平米"),
  CWQD_TT_YLXX("cwqd_tt_ylxx", "娱乐休闲", "门店类型为娱乐休闲，门店面积>0平米"),
  CWQD_CT_ZQ("cwqd_ct_zq", "政企", "门店类型为政企，门店面积>0平米"),
  CWQD_CT_XS("cwqd_ct_xs", "休食", "门店类型为休食，门店面积>0平米"),
  CWQD_CT_YEY("cwqd_ct_yey", "幼儿园", "门店类型为幼儿园，门店面积>0平米"),
  CWQD_TT_XX("cwqd_tt_xx", "小学", "门店类型为小学，门店面积>0平米"),
  CWQD_CT_CZ("cwqd_ct_cz", "初中", "门店类型为初中，门店面积>0平米"),
  CWQD_CT_GZ("cwqd_ct_gz", "高中", "门店类型为高中，门店面积>0平米"),
  CWQD_CT_JNYG("cwqd_ct_jnyg", "九年一贯", "门店类型为九年一贯，门店面积>0平米"),
  CWQD_CT_SQSZD("cwqd_ct_sqszd", "社区食杂店", "门店类型为社区食杂店，门店面积>0平米"),
  CWQD_CT_PSZ("cwqd_ct_psz", "配送", "门店类型配送站，门店面积＜200平米"),
  CWQD_CT_LSCT("cwqd_ct_lsct", "临时出摊", "");
  /**
   * 编码
   */
  private String code;

  /**
   * 值
   */
  private String value;

  /**
   * 值
   */
  private String desc;

  TerminalTypeEnum(String code, String value, String desc) {
    this.code = code;
    this.value = value;
    this.desc = desc;
  }

  /**
   * 根据code转枚举
   *
   * @param code
   * @return
   */
  public static TerminalTypeEnum codeToEnum(String code) {
    TerminalTypeEnum result = null;
    for (TerminalTypeEnum terminalTypeEnum : TerminalTypeEnum.values()) {
      if (terminalTypeEnum.code.equals(code)) {
        result = terminalTypeEnum;
      }
    }
    return result;
  }

  public String getCode() {
    return code;
  }

  public String getValue() {
    return value;
  }

  public String getDesc() {
    return desc;
  }
}
