package com.biz.crm.mdm.business.qywx.synchronize.sdk.vo;

import com.alibaba.fastjson.annotation.JSONField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("客户基本信息")
public class QiYeExternalContact {

  /**
   * 外部id
   *
   */
  @JSONField(name = "external_userid")
  @ApiModelProperty("外部id")
  private String externalUserId;

  @JSONField(name = "name")
  @ApiModelProperty("姓名")
  private String name;

  @JSONField(name = "position")
  @ApiModelProperty("职位")
  private String position;

  @JSONField(name = "type")
  @ApiModelProperty("外部联系人的类型，1表示该外部联系人是微信用户，2表示该外部联系人是企业微信用户")
  private Integer type;

  @JSONField(name = "avatar")
  @ApiModelProperty("外部联系人头像，代开发自建应用需要管理员授权才可以获取，第三方不可获取，上游企业不可获取下游企业客户该字段")
  private String avatar;

  @JSONField(name = "corp_name")
  @ApiModelProperty("外部联系人所在企业的简称，仅当联系人类型是企业微信用户时有此字段")
  private String corpName;

  @JSONField(name = "corp_full_name")
  @ApiModelProperty("外部联系人所在企业的主体名称，仅当联系人类型是企业微信用户时有此字段。" +
          "仅企业自建应用可获取；" +
          "第三方应用、代开发应用、上下游应用不可获取，返回内容为企业名称，即corp_name。")
  private String corpFullName;

  @JSONField(name = "gender")
  @ApiModelProperty("外部联系人性别 0-未知 1-男性 2-女性。第三方不可获取，上游企业不可获取下游企业客户该字段，返回值为0，表示未定义")
  private Integer gender;

  @JSONField(name = "unionid")
  @ApiModelProperty("外部联系人在微信开放平台的唯一身份标识（微信unionid），通过此字段企业可将外部联系人与公众号/小程序用户关联起来。仅当联系人类型是微信用户，且企业绑定了微信开发者ID有此字段。")
  private String unionId;



}
