package com.biz.crm.mdm.business.cost.center.local.dataview;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author: chenlong
 * @date: 2022/11/22 14:30
 * @description: 成本中心映射关系数据视图
 */
@Component
@Slf4j
public class CostCenterRelationDataviewRegister implements DataviewRegister {
    @Override
    public String code() {
        return "mdm_cost_center_relation_data_view";
    }

    @Override
    public String desc() {
        return "MDM-成本中心映射关系";
    }

    @Override
    public String buildSql() {
        return "select t.* from mdm_cost_center_relation t " +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "'";
    }
}
