package com.biz.crm.mdm.business.cost.center.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Description 成本中心映射关系
 * @Author YangWei
 * @Date 2023/3/22 上午9:59
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CostCenterRelation", description = "成本中心映射关系")
@TableName("mdm_cost_center_relation")
@Entity
@Table(name = "mdm_cost_center_relation", indexes = {
    @Index(name = "mdm_cost_center_relation_index1", columnList = "cost_center_code"),
    @Index(name = "mdm_cost_center_relation_index1", columnList = "unique_key", unique = true)
})
@org.hibernate.annotations.Table(appliesTo = "mdm_cost_center_relation", comment = "成本中心映射关系")
public class CostCenterRelation extends TenantFlagOpEntity {

    /**
     * 业务单元编码
     */
    @Column(name = "business_unit_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '业务单元编码'")
    @ApiModelProperty(name = "businessUnitCode", notes = "业务单元编码")
    private String businessUnitCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 部门归口[数据字典:tpm_department_belong]
     */
    @ApiModelProperty(name = "部门归口[数据字典:tpm_department_belong]", notes = "")
    @Column(name = "department_belong_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '部门归口[数据字典:tpm_department_belong] '")
    private String departmentBelongCode;

    /**
     * 费用中心[数据字典:tpm_expense_center]
     */
    @ApiModelProperty(name = "费用中心[数据字典:tpm_expense_center]", notes = "")
    @Column(name = "expense_center", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用中心[数据字典:tpm_expense_center] '")
    private String expenseCenter;

    /**
     * 零售商编码
     */
    @ApiModelProperty(name = "customerRetailerCode", notes = "零售商编码")
    @Column(name = "customer_retailer_code", columnDefinition = "varchar(32) COMMENT '零售商编码'")
    private String customerRetailerCode;

    /**
     * 零售商名称
     */
    @ApiModelProperty(name = "customerRetailerName", notes = "零售商名称")
    @Column(name = "customer_retailer_name", columnDefinition = "varchar(256) COMMENT '零售商名称'")
    private String customerRetailerName;

    /**
     * 零售商区域[数据字典:MDM_CUSTOMIZE_ORG]
     */
    @ApiModelProperty(name = "customerRetailerRegion",value = "零售商区域",notes = "零售商区域[数据字典:MDM_CUSTOMIZE_ORG]")
    @Column(name = "customer_retailer_region", length = 32, columnDefinition = "VARCHAR(32) COMMENT '零售商区域[数据字典:MDM_CUSTOMIZE_ORG] '")
    private String customerRetailerRegion;

    /**
     * 客户渠道编码
     */
    @Column(name = "customer_channel_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码'")
    @ApiModelProperty(value = "客户渠道编码")
    private String customerChannelCode;
    /**
     * 客户渠道名称
     */
    @Column(name = "customer_channel_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户渠道名称'")
    @ApiModelProperty(value = "客户渠道名称")
    private String customerChannelName;

    /**
     * 客户编码
     */
    @ApiModelProperty(name = "customerCode",value = "客户编码", notes = "客户编码")
    @Column(name = "customer_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户编码'")
    private String customerCode;

    /**
     * 客户名称
     */
    @ApiModelProperty(name = "customerName",value = "客户名称", notes = "客户名称")
    @Column(name = "customer_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    /**
     * 销售机构编码
     */
    @ApiModelProperty(name = "salesInstitutionCode",value = "销售机构编码", notes = "销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(name = "salesInstitutionName",value = "销售机构名称", notes = "销售机构名称")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构名称'")
    private String salesInstitutionName;

    /**
     * 销售部门编码
     */
    @ApiModelProperty(name = "salesOrgCode",value = "销售部门编码", notes = "销售部门编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售部门编码'")
    private String salesOrgCode;

    /**
     * 销售部门名称
     */
    @ApiModelProperty(name = "salesOrgName",value = "销售部门名称", notes = "销售部门名称")
    @Column(name = "sales_org_name", length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售部门名称'")
    private String salesOrgName;

    /**
     * 销售组编码
     */
    @ApiModelProperty(name = "salesGroupCode",value = "销售组编码",notes = "销售组编码")
    @Column(name = "sales_group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组编码 '")
    private String salesGroupCode;

    /**
     * 销售组名称
     */
    @ApiModelProperty(name = "salesGroupName",value = "销售组名称",notes = "销售组名称")
    @Column(name = "sales_group_name", nullable = true, length = 64, columnDefinition = "VARCHAR(64) COMMENT '销售组名称'")
    private String salesGroupName;

    /**
     * 成本中心编码
     */
    @ApiModelProperty("成本中心编码")
    @TableField(value = "cost_center_code")
    @Column(name = "cost_center_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 成本中心编码 '")
    private String costCenterCode;

    /**
     * 成本中心名称
     */
    @ApiModelProperty("成本中心名称")
    @TableField(value = "cost_center_name")
    @Column(name = "cost_center_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 成本中心名称 '")
    private String costCenterName;

    /**
     * 唯一key
     */
    @ApiModelProperty("唯一key")
    @TableField(value = "unique_key")
    @Column(name = "unique_key", length = 128, columnDefinition = "VARCHAR(64) COMMENT ' 唯一key '")
    private String uniqueKey;
}