package com.biz.crm.mdm.business.cost.center.local.helper;

import com.biz.crm.mdm.business.cost.center.local.entity.CostCenterRelation;
import com.biz.crm.mdm.business.cost.center.local.repository.ICostCenterRelationRepository;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;

/**
 * @Description 成本中心助手
 * @Author YangWei
 * @Date 2023/3/22 下午2:50
 */
@Slf4j
@Component
public class ICostCenterRelationHelper {

    @Resource
    private ICostCenterRelationRepository iCostCenterRelationRepository;

    /**
     * 非空校验
     * @param dto
     */
    public void verifyEmpty(CostCenterRelationDto dto) {
        Assert.hasText(dto.getCostCenterCode(), "成本中心编码不能为空");
    }

    /**
     * 唯一校验
     * @param dto
     */
    public String verifyUniqueness(CostCenterRelationDto dto) {
        StringBuilder sb = new StringBuilder(this.handleStr(dto.getBusinessFormatCode()));
        sb.append(this.handleStr(dto.getBusinessUnitCode()));
        sb.append(this.handleStr(dto.getExpenseCenter()));
        sb.append(this.handleStr(dto.getCustomerCode()));
        sb.append(this.handleStr(dto.getCustomerRetailerCode()));
        sb.append(this.handleStr(dto.getSalesGroupCode()));
        sb.append(this.handleStr(dto.getSalesInstitutionCode()));
        sb.append(this.handleStr(dto.getSalesOrgCode()));
        sb.append(this.handleStr(dto.getCustomerRetailerRegion()));
        //唯一key
        String uniqueKey = DigestUtils.md5Hex(sb.toString());
        CostCenterRelation entity = this.iCostCenterRelationRepository.findByUniqueKey(uniqueKey);
        Assert.isTrue(ObjectUtils.isEmpty(entity) || entity.getId().equals(dto.getId()), "已经存在数据信息");
        return uniqueKey;
    }

    private String handleStr(String code) {
        return StringUtils.hasText(code) ? code : "&";
    }
}