package com.biz.crm.mdm.business.cost.center.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenter;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterProfitsSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/12/3 11:27
 * @description: 成本中心(CostCenter)表mybatis访问层
 */
public interface CostCenterMapper extends BaseMapper<CostCenter> {

    /**
     * 分页查询所有数据
     *
     * @param page 分页对象
     * @param dto  查询Dto
     * @return 所有数据
     */
    Page<CostCenterVo> findByConditions(@Param("page") Page<CostCenterVo> page, @Param("dto") CostCenterDto dto);

    /**
     * 成本中心下拉
     *
     * @param dto       成本中心查询参数
     * @param limitSize 下拉数量
     * @return 成本中心下拉数据
     */
    List<CommonSelectVo> findFormSelectList(@Param("dto") CostCenterSelectDto dto, @Param("limitSize") int limitSize);

    /**
     * 利润中心下拉
     *
     * @param dto       利润中心查询参数
     * @param limitSize 下拉数量
     * @return 利润中心下拉数据
     */
    List<CommonSelectVo> findProfitsFormSelectList(@Param("dto") CostCenterProfitsSelectDto dto, @Param("limitSize") int limitSize);

    /**
     * 根据条件查询
     * @param dto
     * @return {@link List}<{@link CostCenterVo}>
     */
    List<CostCenterVo> findByCostCenterDto(@Param("dto") CostCenterDto dto);
}
