package com.biz.crm.mdm.business.cost.center.local.repository;

import java.util.ArrayList;
import java.util.List;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenter;
import com.biz.crm.mdm.business.cost.center.local.mapper.CostCenterMapper;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterProfitsSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterSelectDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mn.common.base.constant.CommonSelectConstant;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;

/**
 * @author: chenlong
 * @date: 2022/12/3 11:28
 * @description: 成本中心(CostCenter)表数据库访问层
 */
@Component
public class CostCenterRepository extends ServiceImpl<CostCenterMapper, CostCenter> {

    @Autowired(required = false)
    private CostCenterMapper costCenterMapper;


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param dto      查询Dto
     * @return Page<CostCenterVo>
     */
    public Page<CostCenterVo> findByConditions(Pageable pageable, CostCenterDto dto) {
        Page<CostCenterVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.costCenterMapper.findByConditions(page, dto);
    }

    /**
     * 成本中心下拉
     *
     * @param dto 成本中心查询参数
     * @return 下拉数据
     */
    public List<CommonSelectVo> findFormSelectList(CostCenterSelectDto dto) {
        return costCenterMapper.findFormSelectList(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
    }

    /**
     * 利润中心下拉
     *
     * @param dto 利润中心查询参数
     * @return 下拉数据
     */
    public List<CommonSelectVo> findProfitsFormSelectList(CostCenterProfitsSelectDto dto) {
        return costCenterMapper.findProfitsFormSelectList(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
    }


    /**
     * 批量查询
     *
     * @author huojia
     * @date 2022/12/7 22:15
     * @param costCenterCodeList
     * @return java.util.List<com.biz.crm.tpm.business.account.subject.local.entity.AccountSubjectEntity>
     **/
    public List<CostCenter> findByCostCenterCodes(List<String> costCenterCodeList) {
        if (CollectionUtils.isEmpty(costCenterCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(CostCenter::getCostCenterCode, costCenterCodeList)
                .list();
    }

    /**
     * 根据编码或者名称查询
     * @param codeOrName
     * @return {@link List}<{@link CostCenterVo}>
     */
    public List<CostCenterVo> findByCodeOrName(List<String> codeOrName) {
        Assert.notEmpty(codeOrName, "编码名称查询条件不能为空");
        CostCenterDto dto = new CostCenterDto();
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setCodeOrNameList(codeOrName);
        return this.baseMapper.findByCostCenterDto(dto);
    }
}
