package com.biz.crm.mdm.business.cost.center.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.cost.center.local.entity.CostCenterRelation;
import com.biz.crm.mdm.business.cost.center.local.helper.ICostCenterRelationHelper;
import com.biz.crm.mdm.business.cost.center.local.repository.ICostCenterRelationRepository;
import com.biz.crm.mdm.business.cost.center.local.service.ICostCenterRelationService;
import com.biz.crm.mdm.business.cost.center.sdk.constant.CostCenterConstant;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterRelationDto;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.*;

/**
 * @Description 成本中心映射关系内部接口实现
 * @Author YangWei
 * @Date 2023/3/22 上午11:31
 */
@Slf4j
@Service("iCostCenterRelationService")
public class ICostCenterRelationServiceImpl implements ICostCenterRelationService {

    @Resource
    private ICostCenterRelationRepository iCostCenterRelationRepository;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private DictToolkitService dictToolkitService;

    @Resource
    private ICostCenterRelationHelper iCostCenterRelationHelper;

    /**
     * 新增
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void create(CostCenterRelationDto dto) {
        this.iCostCenterRelationHelper.verifyEmpty(dto);
        String uniqueKey = this.iCostCenterRelationHelper.verifyUniqueness(dto);
        CostCenterRelation entity = this.nebulaToolkitService
            .copyObjectByBlankList(dto, CostCenterRelation.class, HashSet.class, ArrayList.class);
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setUniqueKey(uniqueKey);
        this.iCostCenterRelationRepository.save(entity);
    }

    /**
     * 编辑
     * @param dto
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void update(CostCenterRelationDto dto) {
        Assert.hasText(dto.getId(), "主键ID不能为空");
        this.iCostCenterRelationHelper.verifyEmpty(dto);
        String uniqueKey = this.iCostCenterRelationHelper.verifyUniqueness(dto);
        CostCenterRelation entity = this.nebulaToolkitService
            .copyObjectByBlankList(dto, CostCenterRelation.class, HashSet.class, ArrayList.class);
        entity.setUniqueKey(uniqueKey);
        this.iCostCenterRelationRepository.updateById(entity);
    }

    /**
     * 删除数据
     * @param ids
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        Assert.notEmpty(ids, "请选择要删除的数据信息");
        this.iCostCenterRelationRepository.delete(ids);
    }

    /**
     * 通过主键查询单条数据
     * @param id
     * @return {@link CostCenterRelationVo}
     */
    @Override
    public CostCenterRelationVo findById(String id) {
        CostCenterRelation entity = this.iCostCenterRelationRepository.getById(id);
        return this.nebulaToolkitService
            .copyObjectByBlankList(entity, CostCenterRelationVo.class, HashSet.class, ArrayList.class);
    }

    @Override
    public List<CostCenterRelationVo> findByCondition(CostCenterRelationDto costCenterRelationDto) {
        if (Objects.isNull(costCenterRelationDto)){
            return null;
        }
        List<CostCenterRelationVo> byCondition = iCostCenterRelationRepository.findByCondition(costCenterRelationDto);
        if (CollectionUtil.isNotEmpty(byCondition)) {
            Map<String, String> dictMap = dictToolkitService.findMapByDictTypeCode(CostCenterConstant.DICT_TPM_PROFIT_CENTER);
            for (CostCenterRelationVo vo : byCondition) {
                if (StringUtils.isNotBlank(vo.getProfitCenterCode()) && dictMap.containsKey(vo.getProfitCenterCode())) {
                    vo.setProfitCenterName(dictMap.get(vo.getProfitCenterCode()));
                }
            }
        }
        return byCondition;
    }
}