package com.biz.crm.mdm.business.cost.center.local.service.internal;

import com.biz.crm.mdm.business.cost.center.local.repository.ICostCenterRelationRepository;
import com.biz.crm.mdm.business.cost.center.sdk.dto.CostCenterWithholdingDetailDto;
import com.biz.crm.mdm.business.cost.center.sdk.service.ICostCenterRelationVoService;
import com.biz.crm.mdm.business.cost.center.sdk.vo.CostCenterRelationVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * <p>
 *
 * </p>
 *
 * @author chenshuang
 * @since 2023-03-29
 */
@Service
public class ICostCenterRelationVoServiceImpl implements ICostCenterRelationVoService {
    @Resource
    private ICostCenterRelationRepository iCostCenterRelationRepository;

    @Override
    public Map<String, List<CostCenterRelationVo>> withholdingDetailMap(CostCenterWithholdingDetailDto dto) {
        Validate.notBlank(dto.getBusinessFormatCode(), "业态为空");
        Validate.notBlank(dto.getBusinessUnitCode(), "业务单元为空");
        List<CostCenterRelationVo> vos = iCostCenterRelationRepository.withholdingDetailMap(dto);
        Map<String, List<CostCenterRelationVo>> map = new HashMap<>();
        Map<String, List<CostCenterRelationVo>> verticalMatchKeysMap = vos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getCustomerRetailerRegion())
                        && StringUtils.isNotEmpty(e.getCustomerRetailerCode())
                        && StringUtils.isNotEmpty(e.getExpenseCenter()))
                .collect(Collectors.groupingBy(e -> e.getCustomerRetailerRegion() + e.getCustomerRetailerCode() + e.getExpenseCenter()));
        Map<String, List<CostCenterRelationVo>> cusCostCenterKeysMap = vos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getCustomerCode())
                        && StringUtils.isNotEmpty(e.getExpenseCenter()))
                .collect(Collectors.groupingBy(e -> e.getCustomerCode() + e.getExpenseCenter()));
        Map<String, List<CostCenterRelationVo>> customerCodeKeysMap = vos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getCustomerCode()))
                .collect(Collectors.groupingBy(CostCenterRelationVo::getCustomerCode));
        Map<String, List<CostCenterRelationVo>> groupCodeKeysMap = vos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getSalesGroupCode()))
                .collect(Collectors.groupingBy(CostCenterRelationVo::getSalesGroupCode));
        Map<String, List<CostCenterRelationVo>> departCodeKeysMap = vos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getSalesOrgCode()))
                .collect(Collectors.groupingBy(CostCenterRelationVo::getSalesOrgCode));
        Map<String, List<CostCenterRelationVo>> institutionCodeKeysMap = vos.stream()
                .filter(e -> StringUtils.isNotEmpty(e.getSalesInstitutionCode()))
                .collect(Collectors.groupingBy(CostCenterRelationVo::getSalesInstitutionCode));
        map.putAll(verticalMatchKeysMap);
        map.putAll(cusCostCenterKeysMap);
        map.putAll(customerCodeKeysMap);
        map.putAll(groupCodeKeysMap);
        map.putAll(departCodeKeysMap);
        map.putAll(institutionCodeKeysMap);
        return map;
    }
}
