/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customer.channel.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customer.channel.local.service.ChannelClassificationService;
import com.biz.crm.mdm.business.customer.channel.local.service.ChannelLevelService;
import com.biz.crm.mdm.business.customer.channel.sdk.dto.ChannelClassificationDto;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.ChannelClassificationVo;
import com.biz.crm.mdm.business.customer.channel.sdk.vo.ChannelLevelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/channel/channel"})
@Api(tags={"\u6e20\u9053\u76f8\u5173\u63a5\u53e3"})
public class ChannelController {
    private static final Logger log = LoggerFactory.getLogger(ChannelController.class);
    @Autowired(required=false)
    private ChannelLevelService channelLevelService;
    @Autowired(required=false)
    private ChannelClassificationService channelClassificationService;

    @GetMapping(value={"/channelLevel/findByChannelType"})
    @ApiOperation(value="\u6839\u636e\u6e20\u9053\u7c7b\u578b\u83b7\u53d6\u6e20\u9053\u7b49\u7ea7\u6570\u636e")
    public Result<List<ChannelLevelVo>> findByChannelType(@RequestParam(value="channelType") String channelType) {
        try {
            return Result.ok(this.channelLevelService.findByChannelType(channelType));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"/channelClassification/findChannelClassifications"})
    @ApiOperation(value="\u83b7\u53d6\u6e20\u9053\u5206\u7c7b\u6570\u636e")
    public Result<List<ChannelClassificationVo>> findChannelClassifications(@ApiParam(name="dto", value="\u67e5\u8be2\u53c2\u6570") ChannelClassificationDto dto) {
        try {
            return Result.ok(this.channelClassificationService.findChannelClassifications(dto));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

