package com.biz.crm.mdm.business.customer.org.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantDto;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户组织事件dto
 * @author pengxi
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerOrgEventDto", description = "客户组织事件dto")
public class CustomerOrgEventDto extends TenantDto implements NebulaEventDto {

  @ApiModelProperty(value = "客户组织编码")
  private String customerOrgCode;

  @ApiModelProperty(value = "客户组织名称")
  private String customerOrgName;

  @ApiModelProperty(value = "客户组织层级")
  private String customerOrgLevel;

  @ApiModelProperty(value = "客户组织类型")
  private String customerOrgType;

  @ApiModelProperty(value = "客户组织描述")
  private String customerOrgDesc;

  @ApiModelProperty("上级编码")
  private String parentCode;

  @ApiModelProperty(value = "上级组织名称")
  private String parentName;

}
