package com.biz.crm.mdm.business.customer.org.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantTreeFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @program: crm
 * @description: 客户组织返回vo
 * @author: Bao Hongbin
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CustomerOrgVo", description = "客户组织返回vo")
public class CustomerOrgVo extends TenantTreeFlagOpVo {

  private static final long serialVersionUID = 3381469280008281441L;

  @ApiModelProperty(value = "客户组织编码")
  private String customerOrgCode;

  @ApiModelProperty(value = "客户组织名称")
  private String customerOrgName;

  @ApiModelProperty(value = "客户组织层级")
  private String customerOrgLevel;

  @ApiModelProperty(value = "客户组织类型")
  private String customerOrgType;

  @ApiModelProperty(value = "客户组织描述")
  private String customerOrgDesc;

  @ApiModelProperty("上级编码")
  private String parentCode;

  @ApiModelProperty(value = "上级组织名称")
  private String parentName;

}
