package com.biz.crm.mdm.business.dictionary.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictDataVoFeign;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 数据字典明细表接口实现类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@Service("FeignDictDataVoServiceImpl")
public class DictDataVoServiceImpl implements DictDataVoService {

  @Autowired(required = false)
  private DictDataVoFeign dictDataVoFeign;

  @Override
  public List<DictDataVo> findByDictTypeCode(String dictTypeCode) {
    return this.dictDataVoFeign.findByDictTypeCode(dictTypeCode).checkFeignResult();
  }

  @Override
  public List<DictDataVo> findTreeByDictTypeCode(String dictTypeCode) {
    throw new UnsupportedOperationException();
  }

  @Override
  public List<DictDataVo> findTreeByDictTypeCode(String dictTypeCode, String dictCode) {
    throw new UnsupportedOperationException();
  }

  @Override
  public DictDataVo findById(String id) {
    throw new UnsupportedOperationException();
  }

  @Override
  public DictDataVo findByDictTypeCodeAndDictCode(String dictTypeCode, String dictCode) {
    throw new UnsupportedOperationException();
  }

  @Override
  public Map<String, List<DictDataVo>> findByDictTypeCodeList(List<String> dictTypeCodeList) {
    return this.dictDataVoFeign.findByDictTypeCodeList(dictTypeCodeList).checkFeignResult();
  }

  @Override
  public List<JSONObject> findContainExtendByConditions(DictDataDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void save(DictDataDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void update(DictDataDto dto) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void enableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void disableBatch(List<String> ids) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteByDictTypeCode(String dictTypeCode) {
    throw new UnsupportedOperationException();
  }

  @Override
  public void deleteExtFieldVal(String dictTypeCode, List<String> extList) {
    throw new UnsupportedOperationException();
  }
}
