/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.fiscal.year.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearLinkageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearReconciliationDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.service.FiscalYearVoService;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/fiscalYear/fiscalYear"})
@Api(tags={"\u8d22\u5e74\u4fe1\u606f: FiscalYearVo: \u8d22\u5e74\u8bbe\u7f6e"})
public class FiscalYearVoController {
    private static final Logger log = LoggerFactory.getLogger(FiscalYearVoController.class);
    @Autowired(required=false)
    private FiscalYearVoService fiscalYearVoService;

    @ApiOperation(value="\u5408\u540c/\u9500\u91cf\u76ee\u5f55\u8d22\u5e74\u8054\u52a8\u67e5\u8be2")
    @GetMapping(value={"/findByFiscalYearLinkageDto"})
    public Result<List<FiscalYearVo>> findByFiscalYearLinkageDto(@ApiParam(name="FiscalYearLinkageDto", value="\u67e5\u8be2Dto") FiscalYearLinkageDto dto) {
        try {
            return Result.ok((Object)this.fiscalYearVoService.findByFiscalYearLinkageDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5bf9\u8d26\u89c4\u5219\u6839\u636e\u65f6\u95f4\u6bb5\u67e5\u8be2")
    @GetMapping(value={"/findByFiscalYearReconciliationDto"})
    public Result<List<FiscalYearVo>> findByDateAndFiscalYearType(@ApiParam(name="FiscalYearReconciliationDto", value="\u5bf9\u8d26\u89c4\u5219\u6839\u636e\u65f6\u95f4\u6bb5\u67e5\u8be2Dto") FiscalYearReconciliationDto dto) {
        try {
            return Result.ok((Object)this.fiscalYearVoService.findByFiscalYearReconciliationDto(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u65f6\u95f4\u67e5\u8be2\u8d22\u5e74\u4fe1\u606f")
    @GetMapping(value={"/findByBeginTimeAndEndTime"})
    public Result<List<FiscalYearVo>> findByBeginTimeAndEndTime(@RequestParam(value="beginTime") Date beginTime, @RequestParam(value="endTime") Date endTime) {
        try {
            return Result.ok((Object)this.fiscalYearVoService.findByBeginTimeAndEndTime(beginTime, endTime));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

