/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.fiscal.year.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.fiscal.year.local.entity.FiscalYearEntity;
import com.biz.crm.mdm.business.fiscal.year.local.mapper.FiscalYearMapper;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearLinkageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearPageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.enums.FiscalYearTypeEnum;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class FiscalYearRepository
extends ServiceImpl<FiscalYearMapper, FiscalYearEntity> {
    public List<FiscalYearEntity> findByFiscalYearDto(FiscalYearDto dto) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)dto.getTenantCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<FiscalYearEntity> findByStartTimeAndEndTime(Date startTime, Date endTime, String tenantCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).and(queryWrapper -> {
            queryWrapper.or(qw -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw.between(FiscalYearEntity::getBeginTime, (Object)startTime, (Object)endTime);
            });
            queryWrapper.or(qw -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)qw.between(FiscalYearEntity::getEndTime, (Object)startTime, (Object)endTime);
            });
        })).list();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enableStatus) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enableStatus.getCode())).update();
    }

    public Page<FiscalYearEntity> findByConditions(Pageable pageable, FiscalYearPageDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((FiscalYearMapper)this.baseMapper).findByConditions((Page<FiscalYearEntity>)page, dto);
    }

    public FiscalYearEntity findById(String id) {
        return ((FiscalYearMapper)this.baseMapper).findById(id);
    }

    public List<FiscalYearEntity> findByFiscalYearLinkageDto(FiscalYearLinkageDto dto) {
        List<Object> entities = Lists.newLinkedList();
        if (FiscalYearTypeEnum.YEARLY.getDictCode().equals(dto.getFiscalYearType())) {
            entities = ((FiscalYearMapper)this.baseMapper).findByFiscalYearLinkageYearDto(dto);
        } else {
            FiscalYearEntity byFiscalYearLinkageDto = ((FiscalYearMapper)this.baseMapper).findByFiscalYearLinkageDto(dto);
            if (!ObjectUtils.isEmpty((Object)((Object)byFiscalYearLinkageDto))) {
                entities.add((Object)byFiscalYearLinkageDto);
            }
        }
        return entities;
    }

    public List<FiscalYearVo> findByBeginTimeAndEndTime(Date beginTime, Date endTime) {
        return ((FiscalYearMapper)this.baseMapper).findByBeginTimeAndEndTime(beginTime, endTime, TenantUtils.getTenantCode());
    }
}

