/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.fiscal.year.local.service.internal;

import com.biz.crm.mdm.business.fiscal.year.local.entity.FiscalYearDetailEntity;
import com.biz.crm.mdm.business.fiscal.year.local.repository.FiscalYearDetailRepository;
import com.biz.crm.mdm.business.fiscal.year.local.service.FiscalYearDetailService;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearDetailDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="fiscalYearDetailService")
public class FiscalYearDetailServiceImpl
implements FiscalYearDetailService {
    private static final Logger log = LoggerFactory.getLogger(FiscalYearDetailServiceImpl.class);
    @Autowired(required=false)
    private FiscalYearDetailRepository fiscalYearDetailRepository;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void batchCreate(List<FiscalYearDetailDto> fiscalYearDetailDtos, String year, String tenantCode) {
        List entities = fiscalYearDetailDtos.stream().map(dto -> {
            FiscalYearDetailEntity entity = (FiscalYearDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, FiscalYearDetailEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setYear(year);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        this.fiscalYearDetailRepository.saveBatch(entities);
    }

    @Override
    public void batchUpdate(List<FiscalYearDetailDto> fiscalYearDetailDtos, String year, String tenantCode) {
        this.fiscalYearDetailRepository.deleteByYear(year, tenantCode);
        List entities = fiscalYearDetailDtos.stream().map(dto -> {
            FiscalYearDetailEntity entity = (FiscalYearDetailEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(dto, FiscalYearDetailEntity.class, HashSet.class, ArrayList.class, new String[0])));
            entity.setYear(year);
            entity.setTenantCode(tenantCode);
            return entity;
        }).collect(Collectors.toList());
        this.fiscalYearDetailRepository.saveBatch(entities);
    }
}

