/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.fiscal.year.local.service.internal;

import com.biz.crm.mdm.business.fiscal.year.local.entity.FiscalYearEntity;
import com.biz.crm.mdm.business.fiscal.year.local.repository.FiscalYearRepository;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearLinkageDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.dto.FiscalYearReconciliationDto;
import com.biz.crm.mdm.business.fiscal.year.sdk.enums.FiscalYearReconciliationTypeEnum;
import com.biz.crm.mdm.business.fiscal.year.sdk.enums.FiscalYearTypeEnum;
import com.biz.crm.mdm.business.fiscal.year.sdk.service.FiscalYearVoService;
import com.biz.crm.mdm.business.fiscal.year.sdk.vo.FiscalYearVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service(value="fiscalYearVoService")
public class FiscalYearVoServiceImpl
implements FiscalYearVoService {
    private static final Logger log = LoggerFactory.getLogger(FiscalYearVoServiceImpl.class);
    @Autowired(required=false)
    private FiscalYearRepository fiscalYearRepository;

    public List<FiscalYearVo> findByFiscalYearLinkageDto(FiscalYearLinkageDto dto) {
        if (Objects.isNull(dto) || StringUtils.isBlank((CharSequence)dto.getFiscalYearType())) {
            return Lists.newLinkedList();
        }
        if (FiscalYearTypeEnum.MONTHLY.getDictCode().equals(dto.getFiscalYearType()) || FiscalYearTypeEnum.QUARTER.getDictCode().equals(dto.getFiscalYearType())) {
            Validate.notBlank((CharSequence)dto.getYear(), (String)"\u5e74\u4efd\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<FiscalYearEntity> fiscalYearEntities = this.fiscalYearRepository.findByFiscalYearLinkageDto(dto);
        if (org.apache.commons.lang3.ObjectUtils.isEmpty(fiscalYearEntities)) {
            return Lists.newLinkedList();
        }
        List<Object> list = Lists.newArrayList();
        switch (FiscalYearTypeEnum.getByDictCode((String)dto.getFiscalYearType())) {
            case YEARLY: {
                Map<String, FiscalYearVo> entityMap = fiscalYearEntities.stream().collect(Collectors.toMap(FiscalYearEntity::getYear, o -> {
                    FiscalYearVo linkageVo = new FiscalYearVo();
                    linkageVo.setYear(o.getYear());
                    return linkageVo;
                }, (a, b) -> b));
                list = Lists.newArrayList(entityMap.values()).stream().sorted(Comparator.comparing(FiscalYearVo::getYear)).collect(Collectors.toList());
                break;
            }
            case QUARTER: {
                Map<String, FiscalYearVo> entityMap = fiscalYearEntities.get(0).getFiscalYearDetails().stream().collect(Collectors.toMap(o -> String.format("%s-%s", o.getYear(), o.getQuarter()), o -> {
                    FiscalYearVo linkageVo = new FiscalYearVo();
                    linkageVo.setYear(o.getYear());
                    linkageVo.setQuarter(o.getQuarter());
                    return linkageVo;
                }, (a, b) -> b));
                list = Lists.newArrayList(entityMap.values()).stream().sorted(Comparator.comparing(o -> Integer.valueOf(o.getQuarter()))).collect(Collectors.toList());
                break;
            }
            case MONTHLY: {
                Map<String, FiscalYearVo> entityMap = fiscalYearEntities.get(0).getFiscalYearDetails().stream().collect(Collectors.toMap(o -> String.format("%s-%s-%s", o.getYear(), o.getQuarter(), o.getMonth()), o -> {
                    FiscalYearVo linkageVo = new FiscalYearVo();
                    linkageVo.setYear(o.getYear());
                    linkageVo.setQuarter(o.getQuarter());
                    linkageVo.setMonth(o.getMonth());
                    return linkageVo;
                }, (a, b) -> b));
                list = Lists.newArrayList(entityMap.values()).stream().sorted(Comparator.comparing(o -> Integer.valueOf(o.getMonth()))).collect(Collectors.toList());
                break;
            }
        }
        return list;
    }

    public List<FiscalYearVo> findByFiscalYearReconciliationDto(FiscalYearReconciliationDto dto) {
        if (StringUtils.isBlank((CharSequence)dto.getFiscalYearType())) {
            Validate.notBlank((CharSequence)dto.getFiscalYearType(), (String)"\u8d22\u5e74\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        }
        Validate.isTrue((!ObjectUtils.isEmpty((Object)FiscalYearReconciliationTypeEnum.getByDictCode((String)dto.getFiscalYearType())) ? 1 : 0) != 0, (String)"\u8d22\u5e74\u7c7b\u578b\u9519\u8bef", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)dto.getBeginTime()) ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)dto.getEndTime()) ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setTenantCode(TenantUtils.getTenantCode());
        List<FiscalYearVo> fiscalYearVos = this.fiscalYearRepository.findByBeginTimeAndEndTime(dto.getBeginTime(), dto.getEndTime());
        List<FiscalYearVo> fiscalYearRespList = this.buildByFiscalYearType(dto.getFiscalYearType(), fiscalYearVos);
        return fiscalYearRespList.stream().sorted(Comparator.comparing(FiscalYearVo::getBeginTime)).collect(Collectors.toList());
    }

    private List<FiscalYearVo> buildByFiscalYearType(String fiscalYearType, List<FiscalYearVo> fiscalYearVos) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(fiscalYearVos)) {
            return list;
        }
        Map<Object, Object> fiscalYearMap = Maps.newHashMap();
        switch (FiscalYearReconciliationTypeEnum.getByDictCode((String)fiscalYearType)) {
            case YEARLY: {
                fiscalYearMap = fiscalYearVos.stream().collect(Collectors.groupingBy(FiscalYearVo::getYear));
                this.buildFiscalYearVo(list, fiscalYearMap);
                break;
            }
            case QUARTER: {
                fiscalYearMap = fiscalYearVos.stream().collect(Collectors.groupingBy(o -> String.format("%s-%s", o.getYear(), o.getQuarter())));
                this.buildFiscalYearVo(list, fiscalYearMap);
                break;
            }
            case MONTHLY: {
                fiscalYearMap = fiscalYearVos.stream().collect(Collectors.groupingBy(o -> String.format("%s-%s-%s", o.getYear(), o.getQuarter(), o.getMonth())));
                this.buildFiscalYearVo(list, fiscalYearMap);
                break;
            }
        }
        return list;
    }

    private void buildFiscalYearVo(List<FiscalYearVo> list, Map<String, List<FiscalYearVo>> fiscalYearMap) {
        fiscalYearMap.forEach((k, v) -> {
            FiscalYearVo begin = (FiscalYearVo)v.get(0);
            FiscalYearVo end = (FiscalYearVo)v.get(v.size() - 1);
            FiscalYearVo vo = new FiscalYearVo();
            vo.setYear(begin.getYear());
            vo.setQuarter(begin.getQuarter());
            vo.setMonth(begin.getMonth());
            vo.setId(begin.getId());
            vo.setBeginTime(begin.getBeginTime());
            vo.setEndTime(end.getEndTime());
            list.add(vo);
        });
    }

    public List<FiscalYearVo> findByBeginTimeAndEndTime(Date beginTime, Date endTime) {
        Validate.isTrue((!ObjectUtils.isEmpty((Object)beginTime) ? 1 : 0) != 0, (String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!ObjectUtils.isEmpty((Object)endTime) ? 1 : 0) != 0, (String)"\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.fiscalYearRepository.findByBeginTimeAndEndTime(beginTime, endTime);
    }
}

