package com.biz.crm.mdm.business.inquiry.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.inquiry.sdk.service.InquiryVoService;
import com.biz.crm.mdm.business.inquiry.sdk.vo.InquiryVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 询价: InquiryVo: 询价
 *
 * @author sunx
 * @date 2021-12-30 17:46:07
 */
@Slf4j
@Api(tags = "询价: InquiryVo: 询价")
@RestController
@RequestMapping(value = {"/v1/inquiry/inquiry"})
public class InquiryVoController {

  @Autowired(required = false)
  private InquiryVoService inquiryVoService;

  /**
   * 查询价格
   *
   * @param object
   * @return
   */
  @ApiOperation(value = "查询价格")
  @PostMapping(value = {"/handleSearchPrice"})
  public Result<Map<String, InquiryVo>> handleSearchPrice(@RequestBody JSONObject object) {
    try {
      Map<String, InquiryVo> map = this.inquiryVoService.handleSearchPrice(object);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 询价
   *
   * @param object
   * @return
   */
  @ApiOperation(value = "询价")
  @PostMapping(value = {"/findPrice"})
  public Result<Map<String, InquiryVo>> findPrice(@RequestBody JSONObject object) {
    try {
      Map<String, InquiryVo> map = this.inquiryVoService.findPrice(object);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据业务编码及商品维度询价
   *
   * @param object
   * @return
   */
  @ApiOperation(value = "根据业务编码及商品维度询价")
  @PostMapping(value = {"/findBusinessPrice"})
  public Result<Map<String, InquiryVo>> findBusinessPrice(@RequestBody JSONObject object) {
    try {
      Map<String, InquiryVo> map = this.inquiryVoService.findBusinessPrice(object);
      return Result.ok(map);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
