package com.biz.crm.mdm.business.login.config.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.List;

/**
 * @author jerry7
 * 登录页配置
 */
@EqualsAndHashCode(callSuper = false)
@Data
@ApiModel(value = "IndexConfig", description = "首页配置实体")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`mdm_index_config`", comment = "首页配置实体")
@TableName("mdm_index_config")
@Table(name = "`mdm_index_config`")
public class IndexConfig extends TenantFlagOpEntity {
  private static final long serialVersionUID = -6107448558492088799L;
  /**
   * 类型
   */
  @ApiModelProperty("类型 1：后台，2小程序")
  @Column(name = "data_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 类型 1：后台，2小程序 '")
  private String dataType;
  /**
   * 模板名称
   */
  @ApiModelProperty("模板名称")
  @Column(name = "template_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 模板名称 '")
  private String templateName;
  /**
   * 登录页标题
   */
  @ApiModelProperty("登录页标题")
  @Column(name = "index_title", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 登录页标题 '")
  private String indexTitle;
  /**
   * 服务热线
   */
  @ApiModelProperty("服务热线")
  @Column(name = "service_phone", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 服务热线 '")
  private String servicePhone;
  /**
   * 客服电话
   */
  @ApiModelProperty("客服电话")
  @Column(name = "client_phone", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 客服电话 '")
  private String clientPhone;
  /**
   * 备案号
   */
  @ApiModelProperty("备案号")
  @Column(name = "record_no", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 备案号 '")
  private String recordNo;
  /**
   * 公司名称
   */
  @ApiModelProperty("公司名称")
  @Column(name = "company_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 公司名称 '")
  private String companyName;
  /**
   * 登录按钮颜色
   */
  @ApiModelProperty("登录按钮颜色")
  @Column(name = "button_colour", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 登录按钮颜色 '")
  private String buttonColour;
  /**
   * 底部文字
   */
  @ApiModelProperty("底部文字")
  @Column(name = "bottom_text", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 底部文字 '")
  private String bottomText;
  /**
   * 首行企业logo图片
   */
  @ApiModelProperty("首页企业LOGO图片")
  @Column(name = "logo_url", nullable = false, length = 200, columnDefinition = "VARCHAR(200) COMMENT ' 首行企业logo图片 '")
  private String logoUrl;

  /**
   * 后台logo图片
   */
  @ApiModelProperty("后台LOGO图片")
  @Column(name = "background_logo_url", nullable = false, length = 200, columnDefinition = "VARCHAR(200) COMMENT ' 后台logo图片 '")
  private String backgroundLogoUrl;

  /**
   * dms小程序logo图片
   */
  @ApiModelProperty("dms小程序LOGO图片")
  @Column(name = "dms_logo_url", nullable = false, length = 200, columnDefinition = "VARCHAR(200) COMMENT ' dms小程序logo图片 '")
  private String dmsLogoUrl;

  /**
   * 长中部长轮播时间
   */
  @ApiModelProperty("长中部长轮播时间")
  @Column(name = "logo_time", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 长中部长轮播时间 '")
  private String logoTime;
  /**
   * 首页URL地址
   */
  @ApiModelProperty("首页url地址")
  @Column(name = "pc_first_url", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 首页URL地址 '")
  private String pcFirstUrl;

  @ApiModelProperty("扩展实体")
  @TableField(exist = false)
  @Transient
  private List<IndexConfigExpand> items;
}
