package com.biz.crm.mdm.business.login.config.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author jerry7 参数配置实体类
 */
@EqualsAndHashCode(callSuper = false)
@Data
@ApiModel(value = "ParameterManage", description = "参数配置实体类")
@Entity
@org.hibernate.annotations.Table(appliesTo = "`mdm_parameter_manage`", comment = "参数配置实体类")
@TableName("mdm_parameter_manage")
@Table(name = "`mdm_parameter_manage`")
public class ParameterManage extends TenantFlagOpEntity {
  private static final long serialVersionUID = 1554977653860613921L;

  /**
   * 参数
   */
  @Column(name = "parameter_code", length = 64)
  private String parameterCode;

  /**
   * 参数名称
   */
  @Column(name = "parameter_name", length = 64)
  private String parameterName;

  /**
   * 默认值
   */
  @Column(name = "default_value", length = 64)
  private String defaultValue;

  /**
   * 参数值
   */
  @Column(name = "parameter_value", length = 64)
  private String parameterValue;

  /**
   * 参数说明
   */
  @Column(name = "parameter_explain", length = 64)
  private String parameterExplain;

  /**
   * 所属模块
   */
  @Column(name = "parameter_module", length = 64)
  private String parameterModule;

}
