package com.biz.crm.mdm.business.login.config.repository;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.login.config.dto.IndexConfigDto;
import com.biz.crm.mdm.business.login.config.entity.IndexConfig;
import com.biz.crm.mdm.business.login.config.mapper.IndexConfigMapper;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 登录配置 的 数据库访问类 {@link IndexConfig}
 *
 * @author jerry7
 */
@Component
public class IndexConfigRepository extends ServiceImpl<IndexConfigMapper, IndexConfig> {

  /**
   * 分页条件查询客户物料
   *
   * @param pageable 分页信息
   * @param dto      查询筛选条件
   * @return 分页数据
   */
  public Page<IndexConfig> findByConditions(Page<IndexConfig> pageable, IndexConfigDto dto) {
    return this.baseMapper.findByConditions(pageable, dto);
  }


  /**
   * 根据主键集合，修改 enable_status
   *
   * @param enable
   * @param ids
   */
  public void updateEnableStatusByIdIn(EnableStatusEnum enable, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<IndexConfig> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("enable_status", enable.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  /**
   * 根据主键集合，修改 del_flag
   *
   * @param delFlagStatusEnum 删除标记
   * @param ids               主键id集合
   */
  public void updateDelStatusByIdIn(DelFlagStatusEnum delFlagStatusEnum, List<String> ids) {
    if (CollectionUtils.isEmpty(ids)) {
      return;
    }
    UpdateWrapper<IndexConfig> updateWrapper = new UpdateWrapper<>();
    updateWrapper.set("del_flag", delFlagStatusEnum.getCode());
    updateWrapper.in("id", ids);
    this.update(updateWrapper);
  }

  /**
   * 根据类型查询配置
   * @param dataType 类型
   * @param tenantCode 租户
   * @return
   */
  public List<IndexConfig> findByDataType(String dataType, String tenantCode) {
    return this.lambdaQuery()
        .eq(IndexConfig::getTenantCode, tenantCode)
        .eq(IndexConfig::getDataType,dataType)
        .eq(IndexConfig::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
        .list();
  }
}
