package com.biz.crm.mdm.business.login.config.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.login.config.deprecated.resp.MdmIndexConfigVo;
import com.biz.crm.mdm.business.login.config.dto.IndexConfigDto;
import com.biz.crm.mdm.business.login.config.dto.MdmIndexConfigStopOrOpenOrDeleteDto;
import com.biz.crm.mdm.business.login.config.entity.IndexConfig;
import com.biz.crm.mdm.business.login.config.service.IndexConfigService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.sys.index.controller
 * @Description: TODO
 * @date 2020/11/24 下午12:51
 */
@Api(value = "系统首页配置", tags = "系统首页配置(旧版弃用)")
@RestController
@RequestMapping("/sys/mdmIndexConfigController")
@Deprecated
public class MdmIndexConfigController {
  @Autowired(required = false)
  private IndexConfigService indexConfigService;

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 列表
   */
  @ApiOperation(value = "分页查询列表")
  @PostMapping("/list")
  public Result<PageResult<MdmIndexConfigVo>> list(@RequestBody MdmIndexConfigVo vo) {
    vo = Optional.ofNullable(vo).orElse(new MdmIndexConfigVo());
    IndexConfigDto dto = nebulaToolkitService
            .copyObjectByWhiteList(vo, IndexConfigDto.class, HashSet.class, ArrayList.class);
    Page<IndexConfig> page = indexConfigService
            .findByConditions(PageRequest.of(vo.getPageNum(), vo.getPageSize()), dto);
    PageResult<MdmIndexConfigVo> pageResult = PageResult.<MdmIndexConfigVo>builder()
            .data(new ArrayList<>(nebulaToolkitService
                    .copyCollectionByWhiteList(page.getRecords(), IndexConfig.class, MdmIndexConfigVo.class, HashSet.class, ArrayList.class)))
            .count(page.getTotal())
            .build();

    return Result.ok(pageResult);
  }

  @ApiOperation(value = "启用或停用")
  @PostMapping("/stopOrOpen")
  public Result<?> stopOrOpen(@RequestBody MdmIndexConfigStopOrOpenOrDeleteDto vo) {
    if (EnableStatusEnum.ENABLE.getCode().equals(vo.getEnableStatus())) {
      indexConfigService.enableBatch(vo.getIds());
    } else {
      indexConfigService.disableBatch(vo.getIds());
    }
    return Result.ok();
  }


  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result<?> delete(@RequestBody List<String> ids) {
    indexConfigService.deleteBatch(ids);
    return Result.ok();
  }


  @ApiOperation(value = "详情", httpMethod = "GET")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/detail")
  public Result<MdmIndexConfigVo> detail(@RequestParam("id") String id) {
    Result<MdmIndexConfigVo> result = new Result<>();
    IndexConfig indexConfig = indexConfigService.findById(id);
    MdmIndexConfigVo vo = nebulaToolkitService
            .copyObjectByWhiteList(indexConfig, MdmIndexConfigVo.class, HashSet.class, ArrayList.class);
    result.setResult(vo);
    return result;
  }

  @ApiOperation(value = "保存或者修改", httpMethod = "POST")
  @PostMapping("/saveOrUpdate")
  public Result<MdmIndexConfigVo> saveOrUpdateEntity(@RequestBody MdmIndexConfigVo mdmIndexConfigVo) {
    IndexConfig indexConfig = nebulaToolkitService
            .copyObjectByWhiteList(mdmIndexConfigVo, IndexConfig.class, HashSet.class, ArrayList.class);
    if (StringUtils.isBlank(indexConfig.getId())) {
      indexConfigService.create(indexConfig);
    } else {
      indexConfigService.update(indexConfig);
    }

    return Result.ok(mdmIndexConfigVo);
  }

  @ApiOperation(value = "查询配置", httpMethod = "GET")
  @ApiImplicitParams({
          @ApiImplicitParam(name = "dataType", value = "dataType", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/config")
  public Result<MdmIndexConfigVo> config(@RequestParam("dataType") String dataType) {
    Result<MdmIndexConfigVo> result = new Result<>();
    MdmIndexConfigVo configVo = new MdmIndexConfigVo();
    configVo.setDataType(dataType);
    configVo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    configVo.setPageSize(50);
    configVo.setPageNum(1);
    Result<PageResult<MdmIndexConfigVo>> page = this.list(configVo);
    if (!CollectionUtils.isEmpty(page.getResult().getData())) {
      IndexConfig indexConfig = indexConfigService.findById(page.getResult().getData().get(0).getId());
      result.setResult(nebulaToolkitService
              .copyObjectByWhiteList(indexConfig, MdmIndexConfigVo.class, HashSet.class, ArrayList.class));
    } else {
      result.error500("未配置参数");
    }
    return result;
  }

}
